/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.client.ClientSelectedRole;
import io.prestosql.client.ClientSession;
import io.prestosql.client.Column;
import io.prestosql.client.QueryError;
import io.prestosql.client.QueryStatusInfo;
import io.prestosql.client.StatementClient;
import io.prestosql.client.StatementClientFactory;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.security.AccessControl;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.spi.session.ResourceEstimates;
import io.prestosql.spi.type.Type;
import io.prestosql.testing.ResultWithQueryId;
import io.prestosql.testing.ResultsSession;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.io.Closeable;
import java.net.URI;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.intellij.lang.annotations.Language;

public abstract class AbstractTestingPrestoClient<T>
implements Closeable {
    private final TestingPrestoServer prestoServer;
    private final Session defaultSession;
    private final OkHttpClient httpClient = new OkHttpClient();

    protected AbstractTestingPrestoClient(TestingPrestoServer prestoServer, Session defaultSession) {
        this.prestoServer = Objects.requireNonNull(prestoServer, "prestoServer is null");
        this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    protected abstract ResultsSession<T> getResultSession(Session var1);

    public ResultWithQueryId<T> execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    public ResultWithQueryId<T> execute(Session session, @Language(value="SQL") String sql) {
        ResultsSession<T> resultsSession = this.getResultSession(session);
        ClientSession clientSession = AbstractTestingPrestoClient.toClientSession(session, this.prestoServer.getBaseUrl(), new Duration(2.0, TimeUnit.MINUTES));
        try (StatementClient client = StatementClientFactory.newStatementClient((OkHttpClient)this.httpClient, (ClientSession)clientSession, (String)sql);){
            while (client.isRunning()) {
                resultsSession.addResults(client.currentStatusInfo(), client.currentData());
                client.advance();
            }
            Preconditions.checkState((boolean)client.isFinished());
            QueryError error = client.finalStatusInfo().getError();
            if (error == null) {
                QueryStatusInfo results = client.finalStatusInfo();
                if (results.getUpdateType() != null) {
                    resultsSession.setUpdateType(results.getUpdateType());
                }
                if (results.getUpdateCount() != null) {
                    resultsSession.setUpdateCount(results.getUpdateCount());
                }
                resultsSession.setWarnings(results.getWarnings());
                T result = resultsSession.build(client.getSetSessionProperties(), client.getResetSessionProperties());
                ResultWithQueryId<T> resultWithQueryId = new ResultWithQueryId<T>(new QueryId(results.getId()), result);
                return resultWithQueryId;
            }
            if (error.getFailureInfo() != null) {
                RuntimeException remoteException = error.getFailureInfo().toException();
                throw new RuntimeException(Optional.ofNullable(remoteException.getMessage()).orElseGet(remoteException::toString), remoteException);
            }
            throw new RuntimeException("Query failed: " + error.getMessage());
        }
    }

    private static ClientSession toClientSession(Session session, URI server, Duration clientRequestTimeout) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(session.getSystemProperties());
        for (Map.Entry connectorProperties : session.getUnprocessedCatalogProperties().entrySet()) {
            for (Map.Entry entry2 : ((Map)connectorProperties.getValue()).entrySet()) {
                properties.put((Object)((String)connectorProperties.getKey() + "." + (String)entry2.getKey()), (Object)((String)entry2.getValue()));
            }
        }
        ImmutableMap.Builder resourceEstimates = ImmutableMap.builder();
        ResourceEstimates estimates = session.getResourceEstimates();
        estimates.getExecutionTime().ifPresent(e -> resourceEstimates.put((Object)"EXECUTION_TIME", (Object)e.toString()));
        estimates.getCpuTime().ifPresent(e -> resourceEstimates.put((Object)"CPU_TIME", (Object)e.toString()));
        estimates.getPeakMemoryBytes().ifPresent(e -> resourceEstimates.put((Object)"PEAK_MEMORY", (Object)e.toString()));
        return new ClientSession(server, session.getIdentity().getUser(), (String)session.getSource().orElse(null), session.getTraceToken(), session.getClientTags(), (String)session.getClientInfo().orElse(null), (String)session.getCatalog().orElse(null), (String)session.getSchema().orElse(null), session.getPath().toString(), ZoneId.of(session.getTimeZoneKey().getId()), session.getLocale(), (Map)resourceEstimates.build(), (Map)properties.build(), session.getPreparedStatements(), (Map)session.getIdentity().getRoles().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> new ClientSelectedRole(ClientSelectedRole.Type.valueOf((String)((SelectedRole)entry.getValue()).getType().toString()), ((SelectedRole)entry.getValue()).getRole()))), session.getIdentity().getExtraCredentials(), (String)session.getTransactionId().map(Object::toString).orElse(null), clientRequestTimeout);
    }

    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        return (List)TransactionBuilder.transaction((TransactionManager)this.prestoServer.getTransactionManager(), (AccessControl)this.prestoServer.getAccessControl()).readOnly().execute(session, transactionSession -> this.prestoServer.getMetadata().listTables(transactionSession, new QualifiedTablePrefix(catalog, schema)));
    }

    public boolean tableExists(Session session, String table) {
        return (Boolean)TransactionBuilder.transaction((TransactionManager)this.prestoServer.getTransactionManager(), (AccessControl)this.prestoServer.getAccessControl()).readOnly().execute(session, transactionSession -> MetadataUtil.tableExists((Metadata)this.prestoServer.getMetadata(), (Session)transactionSession, (String)table));
    }

    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public TestingPrestoServer getServer() {
        return this.prestoServer;
    }

    protected List<Type> getTypes(List<Column> columns) {
        return (List)columns.stream().map(Column::getType).map(arg_0 -> ((Metadata)this.prestoServer.getMetadata()).fromSqlType(arg_0)).collect(ImmutableList.toImmutableList());
    }
}

