/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.metadata.AllNodes;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.split.PageSourceManager;
import io.prestosql.split.SplitManager;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.testing.AbstractTestQueries;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.testing.TestingPrestoClient;
import io.prestosql.transaction.TransactionManager;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.intellij.lang.annotations.Language;

public final class StandaloneQueryRunner
implements QueryRunner {
    private final TestingPrestoServer server;
    private final TestingPrestoClient prestoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public StandaloneQueryRunner(Session defaultSession) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        this.server = StandaloneQueryRunner.createTestingPrestoServer();
        this.prestoClient = new TestingPrestoClient(this.server, defaultSession);
        this.refreshNodes();
        this.server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        SessionPropertyManager sessionPropertyManager = this.server.getMetadata().getSessionPropertyManager();
        sessionPropertyManager.addSystemSessionProperties(AbstractTestQueries.TEST_SYSTEM_PROPERTIES);
        sessionPropertyManager.addConnectorSessionProperties(new CatalogName("catalog"), AbstractTestQueries.TEST_CATALOG_PROPERTIES);
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(session, sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void close() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.prestoClient});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
    }

    public int getNodeCount() {
        return 1;
    }

    public Session getDefaultSession() {
        return this.prestoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.server.getTransactionManager();
    }

    public Metadata getMetadata() {
        return this.server.getMetadata();
    }

    public SplitManager getSplitManager() {
        return this.server.getSplitManager();
    }

    public PageSourceManager getPageSourceManager() {
        return this.server.getPageSourceManager();
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.server.getNodePartitioningManager();
    }

    public StatsCalculator getStatsCalculator() {
        return this.server.getStatsCalculator();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.server.getAccessControl();
    }

    public TestingPrestoServer getServer() {
        return this.server;
    }

    public void refreshNodes() {
        AllNodes allNodes;
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((allNodes = this.server.refreshNodes()).getActiveNodes().isEmpty());
    }

    private void refreshNodes(CatalogName catalogName) {
        Set activeNodesWithConnector;
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((activeNodesWithConnector = this.server.getActiveNodesWithConnector(catalogName)).isEmpty());
    }

    public void installPlugin(Plugin plugin) {
        this.server.installPlugin(plugin);
    }

    public void addFunctions(List<? extends SqlFunction> functions) {
        this.server.getMetadata().addFunctions(functions);
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        CatalogName catalog = this.server.createCatalog(catalogName, connectorName, properties);
        this.refreshNodes(catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.prestoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.prestoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    private static TestingPrestoServer createTestingPrestoServer() {
        return TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"node-scheduler.min-candidates", (Object)"1").build()).build();
    }
}

