/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.datatype;

import com.google.common.io.BaseEncoding;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.JsonType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.Function;

public class DataType<T> {
    private final String insertType;
    private final Type prestoResultType;
    private final Function<T, String> toLiteral;
    private final Function<T, String> toPrestoLiteral;
    private final Function<T, ?> toPrestoQueryResult;

    public static DataType<Boolean> booleanDataType() {
        return DataType.dataType("boolean", (Type)BooleanType.BOOLEAN);
    }

    public static DataType<Long> bigintDataType() {
        return DataType.dataType("bigint", (Type)BigintType.BIGINT);
    }

    public static DataType<Integer> integerDataType() {
        return DataType.dataType("integer", (Type)IntegerType.INTEGER);
    }

    public static DataType<Short> smallintDataType() {
        return DataType.dataType("smallint", (Type)SmallintType.SMALLINT);
    }

    public static DataType<Byte> tinyintDataType() {
        return DataType.dataType("tinyint", (Type)TinyintType.TINYINT);
    }

    public static DataType<Float> realDataType() {
        return DataType.dataType("real", (Type)RealType.REAL, value -> {
            if (Float.isFinite(value.floatValue())) {
                return value.toString();
            }
            if (Float.isNaN(value.floatValue())) {
                return "nan()";
            }
            return String.format("%sinfinity()", value.floatValue() > 0.0f ? "+" : "-");
        });
    }

    public static DataType<Double> doubleDataType() {
        return DataType.dataType("double", (Type)DoubleType.DOUBLE, value -> {
            if (Double.isFinite(value)) {
                return value.toString();
            }
            if (Double.isNaN(value)) {
                return "nan()";
            }
            return String.format("%sinfinity()", value > 0.0 ? "+" : "-");
        });
    }

    public static DataType<String> varcharDataType(int size) {
        return DataType.varcharDataType(size, "");
    }

    public static DataType<String> varcharDataType(int size, String properties) {
        return DataType.varcharDataType(Optional.of(size), properties);
    }

    public static DataType<String> varcharDataType() {
        return DataType.varcharDataType(Optional.empty(), "");
    }

    private static DataType<String> varcharDataType(Optional<Integer> length, String properties) {
        String prefix = length.map(size -> "varchar(" + size + ")").orElse("varchar");
        Object suffix = properties.isEmpty() ? "" : " " + properties;
        VarcharType varcharType = length.map(VarcharType::createVarcharType).orElse(VarcharType.createUnboundedVarcharType());
        return DataType.stringDataType(prefix + (String)suffix, (Type)varcharType);
    }

    public static DataType<String> stringDataType(String insertType, Type prestoResultType) {
        return DataType.dataType(insertType, prestoResultType, DataType::formatStringLiteral, Function.identity());
    }

    public static DataType<String> charDataType(int length) {
        return DataType.charDataType(length, "");
    }

    public static DataType<String> charDataType(int length, String properties) {
        Object suffix = properties.isEmpty() ? "" : " " + properties;
        return DataType.charDataType("char(" + length + ")" + (String)suffix, length);
    }

    public static DataType<String> charDataType(String insertType, int length) {
        CharType charType = CharType.createCharType((long)length);
        return DataType.dataType(insertType, (Type)charType, DataType::formatStringLiteral, input -> Chars.padSpaces((String)input, (CharType)charType));
    }

    public static DataType<byte[]> varbinaryDataType() {
        return DataType.dataType("varbinary", (Type)VarbinaryType.VARBINARY, DataType::binaryLiteral, Function.identity());
    }

    public static DataType<BigDecimal> decimalDataType(int precision, int scale) {
        String databaseType = String.format("decimal(%s, %s)", precision, scale);
        return DataType.dataType(databaseType, (Type)DecimalType.createDecimalType((int)precision, (int)scale), bigDecimal -> String.format("CAST('%s' AS %s)", bigDecimal, databaseType), bigDecimal -> bigDecimal.setScale(scale, RoundingMode.UNNECESSARY));
    }

    public static DataType<LocalDate> dateDataType() {
        return DataType.dataType("date", (Type)DateType.DATE, DateTimeFormatter.ofPattern("'DATE '''yyyy-MM-dd''")::format, Function.identity());
    }

    public static DataType<LocalTime> timeDataType() {
        return DataType.dataType("time", (Type)TimeType.TIME, DateTimeFormatter.ofPattern("'TIME '''HH:mm:ss.SSS''")::format, Function.identity());
    }

    public static DataType<LocalDateTime> timestampDataType() {
        return DataType.dataType("timestamp", (Type)TimestampType.TIMESTAMP, DateTimeFormatter.ofPattern("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.SSS''")::format, Function.identity());
    }

    public static DataType<String> jsonDataType() {
        return DataType.dataType("json", (Type)JsonType.JSON, value -> "JSON " + DataType.formatStringLiteral(value), Function.identity());
    }

    public static String formatStringLiteral(String value) {
        return "'" + value.replace("'", "''") + "'";
    }

    public static String binaryLiteral(byte[] value) {
        return "X'" + BaseEncoding.base16().encode(value) + "'";
    }

    private static <T> DataType<T> dataType(String insertType, Type prestoResultType) {
        return new DataType<Object>(insertType, prestoResultType, Object::toString, Object::toString, Function.identity());
    }

    public static <T> DataType<T> dataType(String insertType, Type prestoResultType, Function<T, String> toLiteral) {
        return new DataType<T>(insertType, prestoResultType, toLiteral, toLiteral, Function.identity());
    }

    public static <T> DataType<T> dataType(String insertType, Type prestoResultType, Function<T, String> toLiteral, Function<T, ?> toPrestoQueryResult) {
        return new DataType<T>(insertType, prestoResultType, toLiteral, toLiteral, toPrestoQueryResult);
    }

    public static <T> DataType<T> dataType(String insertType, Type prestoResultType, Function<T, String> toLiteral, Function<T, String> toPrestoLiteral, Function<T, ?> toPrestoQueryResult) {
        return new DataType<T>(insertType, prestoResultType, toLiteral, toPrestoLiteral, toPrestoQueryResult);
    }

    private DataType(String insertType, Type prestoResultType, Function<T, String> toLiteral, Function<T, String> toPrestoLiteral, Function<T, ?> toPrestoQueryResult) {
        this.insertType = insertType;
        this.prestoResultType = prestoResultType;
        this.toLiteral = toLiteral;
        this.toPrestoLiteral = toPrestoLiteral;
        this.toPrestoQueryResult = toPrestoQueryResult;
    }

    public String toLiteral(T inputValue) {
        if (inputValue == null) {
            return "NULL";
        }
        return this.toLiteral.apply(inputValue);
    }

    public String toPrestoLiteral(T inputValue) {
        if (inputValue == null) {
            return "NULL";
        }
        return this.toPrestoLiteral.apply(inputValue);
    }

    public Object toPrestoQueryResult(T inputValue) {
        if (inputValue == null) {
            return null;
        }
        return this.toPrestoQueryResult.apply(inputValue);
    }

    public String getInsertType() {
        return this.insertType;
    }

    public Type getPrestoResultType() {
        return this.prestoResultType;
    }
}

