/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.sql;

import io.prestosql.testing.sql.SqlExecutor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class JdbcSqlExecutor
implements SqlExecutor {
    private final String jdbcUrl;
    private final Properties jdbcProperties;

    public JdbcSqlExecutor(String jdbcUrl) {
        this(jdbcUrl, new Properties());
    }

    public JdbcSqlExecutor(String jdbcUrl, Properties jdbcProperties) {
        this.jdbcUrl = Objects.requireNonNull(jdbcUrl, "jdbcUrl is null");
        this.jdbcProperties = new Properties();
        this.jdbcProperties.putAll((Map<?, ?>)Objects.requireNonNull(jdbcProperties, "jdbcProperties is null"));
    }

    @Override
    public void execute(String sql) {
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl, this.jdbcProperties);
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing sql:\n" + sql, e);
        }
    }
}

