/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.sql;

import com.google.common.collect.ImmutableList;
import io.prestosql.testing.sql.SqlExecutor;
import java.security.SecureRandom;
import java.util.List;

public class TestTable
implements AutoCloseable {
    private static final SecureRandom random = new SecureRandom();
    private static final int RANDOM_SUFFIX_LENGTH = 5;
    private final SqlExecutor sqlExecutor;
    private final String name;

    public TestTable(SqlExecutor sqlExecutor, String namePrefix, String tableDefinition) {
        this(sqlExecutor, namePrefix, tableDefinition, (List<String>)ImmutableList.of());
    }

    public TestTable(SqlExecutor sqlExecutor, String namePrefix, String tableDefinition, List<String> rowsToInsert) {
        this.sqlExecutor = sqlExecutor;
        this.name = namePrefix + "_" + TestTable.randomTableSuffix();
        sqlExecutor.execute(String.format("CREATE TABLE %s %s", this.name, tableDefinition));
        try {
            for (String row : rowsToInsert) {
                sqlExecutor.execute(String.format("INSERT INTO %s VALUES (%s)", this.name, row));
            }
        }
        catch (Exception e) {
            TestTable ignored = this;
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.sqlExecutor.execute("DROP TABLE " + this.name);
    }

    public static String randomTableSuffix() {
        String randomSuffix = Long.toString(Math.abs(random.nextLong()), 36);
        return randomSuffix.substring(0, Math.min(5, randomSuffix.length()));
    }
}

