/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.tpch;

import io.prestosql.spi.connector.ConnectorIndex;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.testing.tpch.TpchIndexedData;
import java.util.Objects;
import java.util.function.Function;

class TpchConnectorIndex
implements ConnectorIndex {
    private final Function<RecordSet, RecordSet> keyFormatter;
    private final Function<RecordSet, RecordSet> outputFormatter;
    private final TpchIndexedData.IndexedTable indexedTable;

    public TpchConnectorIndex(Function<RecordSet, RecordSet> keyFormatter, Function<RecordSet, RecordSet> outputFormatter, TpchIndexedData.IndexedTable indexedTable) {
        this.keyFormatter = Objects.requireNonNull(keyFormatter, "keyFormatter is null");
        this.outputFormatter = Objects.requireNonNull(outputFormatter, "outputFormatter is null");
        this.indexedTable = Objects.requireNonNull(indexedTable, "indexedTable is null");
    }

    public ConnectorPageSource lookup(RecordSet rawInputRecordSet) {
        RecordSet inputRecordSet = this.keyFormatter.apply(rawInputRecordSet);
        RecordSet rawOutputRecordSet = this.indexedTable.lookupKeys(inputRecordSet);
        return new RecordPageSource(this.outputFormatter.apply(rawOutputRecordSet));
    }
}

