/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.prestosql.Session;
import io.prestosql.metadata.FunctionListBuilder;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.operator.scalar.ApplyFunction;
import io.prestosql.operator.scalar.InvokeFunction;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.AbstractTestQueryFramework;
import io.prestosql.testing.CreateHll;
import io.prestosql.testing.CustomAdd;
import io.prestosql.testing.CustomRank;
import io.prestosql.testing.CustomSum;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.StatefulSleepingSum;
import io.prestosql.testing.assertions.Assert;
import io.prestosql.tests.QueryTemplate;
import io.prestosql.tpch.TpchTable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractTestQueries
extends AbstractTestQueryFramework {
    protected static final List<SqlFunction> CUSTOM_FUNCTIONS = new FunctionListBuilder().aggregates(CustomSum.class).window(CustomRank.class).scalars(CustomAdd.class).scalars(CreateHll.class).functions(new SqlFunction[]{ApplyFunction.APPLY_FUNCTION, InvokeFunction.INVOKE_FUNCTION, StatefulSleepingSum.STATEFUL_SLEEPING_SUM}).getFunctions();
    public static final List<PropertyMetadata<?>> TEST_SYSTEM_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"test_string", (String)"test string property", (String)"test default", (boolean)false), (Object)PropertyMetadata.longProperty((String)"test_long", (String)"test long property", (Long)42L, (boolean)false));
    public static final List<PropertyMetadata<?>> TEST_CATALOG_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"connector_string", (String)"connector string property", (String)"connector default", (boolean)false), (Object)PropertyMetadata.longProperty((String)"connector_long", (String)"connector long property", (Long)33L, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"connector_boolean", (String)"connector boolean property", (Boolean)true, (boolean)false), (Object)PropertyMetadata.doubleProperty((String)"connector_double", (String)"connector double property", (Double)99.0, (boolean)false));

    @Test
    public void testAggregationOverUnknown() {
        this.assertQuery("SELECT clerk, min(totalprice), max(totalprice), min(nullvalue), max(nullvalue) FROM (SELECT clerk, totalprice, null AS nullvalue FROM orders) GROUP BY clerk");
    }

    @Test
    public void testLimitIntMax() {
        this.assertQuery("SELECT orderkey FROM orders LIMIT 2147483647");
        this.assertQuery("SELECT orderkey FROM orders ORDER BY orderkey LIMIT 2147483647");
    }

    @Test
    public void testNonDeterministic() {
        MaterializedResult materializedResult = this.computeActual("SELECT rand() FROM orders LIMIT 10");
        long distinctCount = materializedResult.getMaterializedRows().stream().map(row -> row.getField(0)).distinct().count();
        org.testng.Assert.assertTrue((distinctCount >= 8L ? 1 : 0) != 0, (String)"rand() must produce different rows");
        materializedResult = this.computeActual("SELECT apply(1, x -> x + rand()) FROM orders LIMIT 10");
        distinctCount = materializedResult.getMaterializedRows().stream().map(row -> row.getField(0)).distinct().count();
        org.testng.Assert.assertTrue((distinctCount >= 8L ? 1 : 0) != 0, (String)"rand() must produce different rows");
    }

    @Test
    public void testComplexQuery() {
        this.assertQueryOrdered("SELECT sum(orderkey), row_number() OVER (ORDER BY orderkey) FROM orders WHERE orderkey <= 10 GROUP BY orderkey HAVING sum(orderkey) >= 3 ORDER BY orderkey DESC LIMIT 3", "VALUES (7, 5), (6, 4), (5, 3)");
    }

    @Test
    public void testDistinctMultipleFields() {
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM orders");
    }

    @Test
    public void testArithmeticNegation() {
        this.assertQuery("SELECT -custkey FROM orders");
    }

    @Test
    public void testDistinct() {
        this.assertQuery("SELECT DISTINCT custkey FROM orders");
    }

    @Test
    public void testDistinctHaving() {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) AS count FROM orders GROUP BY orderdate HAVING COUNT(DISTINCT clerk) > 1");
    }

    @Test
    public void testDistinctLimit() {
        this.assertQuery("SELECT DISTINCT orderstatus, custkey FROM (SELECT orderstatus, custkey FROM orders ORDER BY orderkey LIMIT 10) LIMIT 10");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT DISTINCT orderstatus, custkey FROM orders LIMIT 10)");
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM orders WHERE custkey = 1268 LIMIT 2");
        this.assertQuery("SELECT DISTINCT x FROM (VALUES 1) t(x) JOIN (VALUES 10, 20) u(a) ON t.x < u.a LIMIT 100", "SELECT 1");
    }

    @Test
    public void testDistinctWithOrderBy() {
        this.assertQueryOrdered("SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 10");
    }

    @Test
    public void testRepeatedAggregations() {
        this.assertQuery("SELECT SUM(orderkey), SUM(orderkey) FROM orders");
    }

    @Test
    public void testRepeatedOutputs() {
        this.assertQuery("SELECT orderkey a, orderkey b FROM orders WHERE orderstatus = 'F'");
    }

    @Test
    public void testRepeatedOutputs2() {
        this.assertQuery("SELECT orderdate, orderdate, orderkey FROM orders");
    }

    @Test
    public void testLimit() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitWithAggregation() {
        MaterializedResult actual = this.computeActual("SELECT custkey, SUM(CAST(totalprice * 100 AS BIGINT)) FROM orders GROUP BY custkey LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT custkey, SUM(CAST(totalprice * 100 AS BIGINT)) FROM orders GROUP BY custkey", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitInInlineView() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM (SELECT orderkey FROM orders LIMIT 100) T LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testCountAll() {
        this.assertQuery("SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(42) FROM orders", "SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(42 + 42) FROM orders", "SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(null) FROM orders", "SELECT 0");
    }

    @Test
    public void testCountColumn() {
        this.assertQuery("SELECT COUNT(orderkey) FROM orders");
        this.assertQuery("SELECT COUNT(orderstatus) FROM orders");
        this.assertQuery("SELECT COUNT(orderdate) FROM orders");
        this.assertQuery("SELECT COUNT(1) FROM orders");
        this.assertQuery("SELECT COUNT(NULLIF(orderstatus, 'F')) FROM orders");
        this.assertQuery("SELECT COUNT(CAST(NULL AS BIGINT)) FROM orders");
    }

    @Test
    public void testSelectAllFromTable() {
        this.assertQuery("SELECT * FROM orders");
        this.assertQuery("SELECT *, 123, * FROM orders");
        this.assertQuery("SELECT orders.* FROM orders");
        this.assertQuery("SELECT *, orders.*, orderkey FROM orders");
        this.assertQuery("SELECT T.* FROM orders T");
        this.assertQuery("SELECT a, b, c, d FROM (SELECT T.* FROM nation T (a, b, c, d))");
        this.assertQuery("SELECT T.* FROM (SELECT orderkey + custkey FROM orders) T");
        this.assertQuery("SELECT name FROM (SELECT * FROM region ORDER BY name DESC LIMIT 2)", "VALUES 'MIDDLE EAST', 'EUROPE'");
        this.assertQuery("SELECT y FROM (SELECT r.* AS (x, y, z) FROM region r ORDER BY name DESC LIMIT 2)", "VALUES 'MIDDLE EAST', 'EUROPE'");
        this.assertQuery("SELECT y FROM (SELECT r.* AS (x, y, z) FROM region r ORDER BY y DESC LIMIT 2)", "VALUES 'MIDDLE EAST', 'EUROPE'");
    }

    @Test
    public void testAverageAll() {
        this.assertQuery("SELECT AVG(totalprice) FROM orders");
    }

    @Test
    public void testRollupOverUnion() {
        this.assertQuery("SELECT orderstatus, sum(orderkey)\nFROM (SELECT orderkey, orderstatus\n      FROM orders\n      UNION ALL\n      SELECT orderkey, orderstatus\n      FROM orders) x\nGROUP BY ROLLUP (orderstatus)", "VALUES ('P', 21470000),\n('O', 439774330),\n('F', 438500670),\n(NULL, 899745000)");
        this.assertQuery("SELECT regionkey, count(*) FROM (   SELECT regionkey FROM nation    UNION ALL    SELECT * FROM (VALUES 2, 100) t(regionkey)) GROUP BY ROLLUP (regionkey)", "SELECT * FROM (VALUES  (0, 5), (1, 5), (2, 6), (3, 5), (4, 5), (100, 1), (NULL, 27))");
    }

    @Test
    public void testIntersect() {
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21");
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT DISTINCT SELECT regionkey FROM nation WHERE nationkey > 21", "VALUES 1, 3");
        this.assertQuery("WITH wnation AS (SELECT nationkey, regionkey FROM nation) SELECT regionkey FROM wnation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM wnation WHERE nationkey > 21", "VALUES 1, 3");
        this.assertQuery("SELECT num FROM (SELECT 1 AS num FROM nation WHERE nationkey=10 INTERSECT SELECT 1 FROM nation WHERE nationkey=20) T");
        this.assertQuery("SELECT nationkey, nationkey / 2 FROM (SELECT nationkey FROM nation WHERE nationkey < 10 INTERSECT SELECT nationkey FROM nation WHERE nationkey > 4) T WHERE nationkey % 2 = 0");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION SELECT 4");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 UNION SELECT regionkey FROM nation WHERE nationkey > 21) INTERSECT SELECT 1");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 3");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 3");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) INTERSECT SELECT * FROM (VALUES 1.0, 2)", "VALUES 1.0, 2.0");
        this.assertQuery("SELECT NULL, NULL INTERSECT SELECT NULL, NULL FROM nation");
        MaterializedResult emptyResult = this.computeActual("SELECT 100 INTERSECT (SELECT regionkey FROM nation WHERE nationkey <10)");
        Assert.assertEquals((int)emptyResult.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testIntersectWithAggregation() {
        this.assertQuery("SELECT COUNT(*) FROM nation INTERSECT SELECT COUNT(regionkey) FROM nation HAVING SUM(regionkey) IS NOT NULL");
        this.assertQuery("SELECT SUM(nationkey), COUNT(name) FROM (SELECT nationkey,name FROM nation INTERSECT SELECT regionkey, name FROM nation) n");
        this.assertQuery("SELECT COUNT(*) * 2 FROM nation INTERSECT (SELECT SUM(nationkey) FROM nation GROUP BY regionkey ORDER BY 1 LIMIT 2)");
        this.assertQuery("SELECT COUNT(a) FROM (SELECT nationkey AS a FROM (SELECT nationkey FROM nation INTERSECT SELECT regionkey FROM nation) n1 INTERSECT SELECT regionkey FROM nation) n2");
        this.assertQuery("SELECT COUNT(*), SUM(2), regionkey FROM (SELECT nationkey, regionkey FROM nation INTERSECT SELECT regionkey, regionkey FROM nation) n GROUP BY regionkey");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT nationkey FROM nation INTERSECT SELECT 2) n1 INTERSECT SELECT regionkey FROM nation");
    }

    @Test
    public void testExcept() {
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21");
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT DISTINCT SELECT regionkey FROM nation WHERE nationkey > 21", "VALUES 0, 4");
        this.assertQuery("WITH wnation AS (SELECT nationkey, regionkey FROM nation) SELECT regionkey FROM wnation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM wnation WHERE nationkey > 21", "VALUES 0, 4");
        this.assertQuery("SELECT num FROM (SELECT 1 AS num FROM nation WHERE nationkey=10 EXCEPT SELECT 2 FROM nation WHERE nationkey=20) T");
        this.assertQuery("SELECT nationkey, nationkey / 2 FROM (SELECT nationkey FROM nation WHERE nationkey < 10 EXCEPT SELECT nationkey FROM nation WHERE nationkey > 4) T WHERE nationkey % 2 = 0");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21) UNION SELECT 3");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 UNION SELECT regionkey FROM nation WHERE nationkey > 21) EXCEPT SELECT 1");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 4");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) EXCEPT SELECT * FROM (VALUES 3.0, 2)");
        this.assertQuery("SELECT NULL, NULL EXCEPT SELECT NULL, NULL FROM nation");
        this.assertQuery("(SELECT * FROM (VALUES 1) EXCEPT SELECT * FROM (VALUES 0))EXCEPT (SELECT * FROM (VALUES 1) EXCEPT SELECT * FROM (VALUES 1))");
        MaterializedResult emptyResult = this.computeActual("SELECT 0 EXCEPT (SELECT regionkey FROM nation WHERE nationkey <10)");
        Assert.assertEquals((int)emptyResult.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testExceptWithAggregation() {
        this.assertQuery("SELECT COUNT(*) FROM nation EXCEPT SELECT COUNT(regionkey) FROM nation WHERE regionkey < 3 HAVING SUM(regionkey) IS NOT NULL");
        this.assertQuery("SELECT SUM(nationkey), COUNT(name) FROM (SELECT nationkey, name FROM nation WHERE nationkey < 6 EXCEPT SELECT regionkey, name FROM nation) n");
        this.assertQuery("(SELECT SUM(nationkey) FROM nation GROUP BY regionkey ORDER BY 1 LIMIT 2) EXCEPT SELECT COUNT(*) * 2 FROM nation");
        this.assertQuery("SELECT COUNT(a) FROM (SELECT nationkey AS a FROM (SELECT nationkey FROM nation EXCEPT SELECT regionkey FROM nation) n1 EXCEPT SELECT regionkey FROM nation) n2");
        this.assertQuery("SELECT COUNT(*), SUM(2), regionkey FROM (SELECT nationkey, regionkey FROM nation EXCEPT SELECT regionkey, regionkey FROM nation) n GROUP BY regionkey HAVING regionkey < 3");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT nationkey FROM nation EXCEPT SELECT 10) n1 EXCEPT SELECT regionkey FROM nation");
    }

    @Test
    public void testSelectWithComparison() {
        this.assertQuery("SELECT orderkey FROM lineitem WHERE tax < discount");
    }

    @Test
    public void testInlineView() {
        this.assertQuery("SELECT orderkey, custkey FROM (SELECT orderkey, custkey FROM orders) U");
    }

    @Test
    public void testAliasedInInlineView() {
        this.assertQuery("SELECT x, y FROM (SELECT orderkey x, custkey y FROM orders) U");
    }

    @Test
    public void testInlineViewWithProjections() {
        this.assertQuery("SELECT x + 1, y FROM (SELECT orderkey * 10 x, custkey y FROM orders) u");
    }

    @Test
    public void testMaxBy() {
        this.assertQuery("SELECT MAX_BY(orderkey, totalprice) FROM orders", "SELECT orderkey FROM orders ORDER BY totalprice DESC LIMIT 1");
    }

    @Test
    public void testMaxByN() {
        this.assertQuery("SELECT y FROM (SELECT MAX_BY(orderkey, totalprice, 2) mx FROM orders) CROSS JOIN UNNEST(mx) u(y)", "SELECT orderkey FROM orders ORDER BY totalprice DESC LIMIT 2");
    }

    @Test
    public void testMinBy() {
        this.assertQuery("SELECT MIN_BY(orderkey, totalprice) FROM orders", "SELECT orderkey FROM orders ORDER BY totalprice ASC LIMIT 1");
        this.assertQuery("SELECT MIN_BY(a, ROW(b, c)) FROM (VALUES (1, 2, 3), (2, 2, 1)) AS t(a, b, c)", "SELECT 2");
    }

    @Test
    public void testMinByN() {
        this.assertQuery("SELECT y FROM (SELECT MIN_BY(orderkey, totalprice, 2) mx FROM orders) CROSS JOIN UNNEST(mx) u(y)", "SELECT orderkey FROM orders ORDER BY totalprice ASC LIMIT 2");
    }

    @Test
    public void testHaving() {
        this.assertQuery("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus HAVING orderstatus = 'O'");
    }

    @Test
    public void testHaving2() {
        this.assertQuery("SELECT custkey, sum(orderkey) FROM orders GROUP BY custkey HAVING sum(orderkey) > 400000");
    }

    @Test
    public void testHaving3() {
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, avg(totalprice + 5) FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey HAVING avg(totalprice + 5) > 10");
    }

    @Test
    public void testHavingWithoutGroupBy() {
        this.assertQuery("SELECT sum(orderkey) FROM orders HAVING sum(orderkey) > 400000");
    }

    @Test
    public void testColumnAliases() {
        this.assertQuery("SELECT x, T.y, z + 1 FROM (SELECT custkey, orderstatus, totalprice FROM orders) T (x, y, z)", "SELECT custkey, orderstatus, totalprice + 1 FROM orders");
        this.assertQuery("SELECT a, b, c FROM (SELECT T.* FROM region T (a, b, c))");
    }

    @Test
    public void testCast() {
        this.assertQuery("SELECT CAST('1' AS BIGINT)");
        this.assertQuery("SELECT CAST(totalprice AS BIGINT) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS DOUBLE) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS BOOLEAN) FROM orders");
        this.assertQuery("SELECT try_cast('1' AS BIGINT)", "SELECT CAST('1' AS BIGINT)");
        this.assertQuery("SELECT try_cast(totalprice AS BIGINT) FROM orders", "SELECT CAST(totalprice AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS DOUBLE) FROM orders", "SELECT CAST(orderkey AS DOUBLE) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS VARCHAR) FROM orders", "SELECT CAST(orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS BOOLEAN) FROM orders", "SELECT CAST(orderkey AS BOOLEAN) FROM orders");
        this.assertQuery("SELECT try_cast('foo' AS BIGINT)", "SELECT CAST(null AS BIGINT)");
        this.assertQuery("SELECT try_cast(clerk AS BIGINT) FROM orders", "SELECT CAST(null AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey * orderkey AS VARCHAR) FROM orders", "SELECT CAST(orderkey * orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT try_cast(try_cast(orderkey AS VARCHAR) AS BIGINT) FROM orders", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT try_cast(clerk AS VARCHAR) || try_cast(clerk AS VARCHAR) FROM orders", "SELECT clerk || clerk FROM orders");
        this.assertQuery("SELECT coalesce(try_cast('foo' AS BIGINT), 456)", "SELECT 456");
        this.assertQuery("SELECT coalesce(try_cast(clerk AS BIGINT), 456) FROM orders", "SELECT 456 FROM orders");
        this.assertQuery("SELECT CAST(x AS BIGINT) FROM (VALUES 1, 2, 3, NULL) t (x)", "VALUES 1, 2, 3, NULL");
        this.assertQuery("SELECT try_cast(x AS BIGINT) FROM (VALUES 1, 2, 3, NULL) t (x)", "VALUES 1, 2, 3, NULL");
    }

    @Test
    public void testQuotedIdentifiers() {
        this.assertQuery("SELECT \"TOTALPRICE\" \"my price\" FROM \"ORDERS\"");
    }

    @Test
    public void testIn() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1.5, 2.3)", "SELECT orderkey FROM orders LIMIT 0");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2E0, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE totalprice IN (1, 2, 3)");
    }

    @Test(dataProvider="largeInValuesCount")
    public void testLargeIn(int valuesCount) {
        String longValues = IntStream.range(0, valuesCount).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (mod(1000, orderkey), " + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (mod(1000, orderkey), " + longValues + ")");
    }

    @DataProvider
    public static Object[][] largeInValuesCount() {
        return new Object[][]{{200}, {500}, {1000}, {5000}};
    }

    @Test
    public void testShowSchemas() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)((String)this.getSession().getSchema().get()), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasFrom() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS FROM %s", this.getSession().getCatalog().get()));
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)((String)this.getSession().getSchema().get()), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasLike() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS LIKE '%s'", this.getSession().getSchema().get()));
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)((String)this.getSession().getSchema().get())));
    }

    @Test
    public void testShowSchemasLikeWithEscape() {
        this.assertQueryFails("SHOW SCHEMAS LIKE 't$_%' ESCAPE ''", "Escape string must be a single character");
        this.assertQueryFails("SHOW SCHEMAS LIKE 't$_%' ESCAPE '$$'", "Escape string must be a single character");
        Set allSchemas = this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet();
        Assert.assertEquals((Set)allSchemas, (Set)this.computeActual("SHOW SCHEMAS LIKE '%_%'").getOnlyColumnAsSet());
        Set result = this.computeActual("SHOW SCHEMAS LIKE '%$_%' ESCAPE '$'").getOnlyColumnAsSet();
        org.testng.Assert.assertNotEquals((Object)allSchemas, (Object)result);
        Assertions.assertThat((Iterable)result).contains(new Object[]{"information_schema"}).allMatch(schemaName -> ((String)schemaName).contains("_"));
    }

    @Test
    public void testShowTables() {
        Set expectedTables = (Set)TpchTable.getTables().stream().map(TpchTable::getTableName).collect(ImmutableSet.toImmutableSet());
        MaterializedResult result = this.computeActual("SHOW TABLES");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll(expectedTables));
    }

    @Test
    public void testShowTablesFrom() {
        Set expectedTables = (Set)TpchTable.getTables().stream().map(TpchTable::getTableName).collect(ImmutableSet.toImmutableSet());
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        MaterializedResult result = this.computeActual("SHOW TABLES FROM " + schema);
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll(expectedTables));
        result = this.computeActual("SHOW TABLES FROM " + catalog + "." + schema);
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll(expectedTables));
        this.assertQueryFails("SHOW TABLES FROM UNKNOWN", "line 1:1: Schema 'unknown' does not exist");
        this.assertQueryFails("SHOW TABLES FROM UNKNOWNCATALOG.UNKNOWNSCHEMA", "line 1:1: Catalog 'unknowncatalog' does not exist");
    }

    @Test
    public void testShowTablesLike() {
        Assertions.assertThat((Iterable)this.computeActual("SHOW TABLES LIKE 'or%'").getOnlyColumnAsSet()).contains(new Object[]{"orders"}).allMatch(tableName -> ((String)tableName).startsWith("or"));
    }

    @Test
    public void testShowColumns() {
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM orders");
        MaterializedResult expectedUnparametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
        MaterializedResult expectedParametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        org.testng.Assert.assertTrue((actual.equals((Object)expectedParametrizedVarchar) || actual.equals((Object)expectedUnparametrizedVarchar) ? 1 : 0) != 0, (String)String.format("%s does not matche neither of %s and %s", actual, expectedParametrizedVarchar, expectedUnparametrizedVarchar));
    }

    @Test
    public void testInformationSchemaFiltering() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'orders' LIMIT 1", "SELECT 'orders' table_name");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE data_type = 'bigint' AND table_name = 'customer' and column_name = 'custkey' LIMIT 1", "SELECT 'customer' table_name");
    }

    @Test
    public void testInformationSchemaUppercaseName() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'LOCAL'", "SELECT '' WHERE false");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'TINY'", "SELECT '' WHERE false");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'ORDERS'", "SELECT '' WHERE false");
    }

    @Test
    public void testSelectColumnOfNulls() {
        this.assertQueryOrdered("SELECT CAST(NULL AS VARCHAR), CAST(NULL AS BIGINT) FROM orders ORDER BY 1");
    }

    @Test
    public void testSelectCaseInsensitive() {
        this.assertQuery("SELECT ORDERKEY FROM ORDERS");
        this.assertQuery("SELECT OrDeRkEy FROM OrDeRs");
    }

    @Test
    public void testTopN() {
        this.assertQuery("SELECT n.name, r.name FROM nation n LEFT JOIN region r ON n.regionkey = r.regionkey ORDER BY n.name LIMIT 1");
    }

    @Test
    public void testTopNByMultipleFields() {
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS LAST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC, custkey ASC LIMIT 10", "SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC LIMIT 10");
    }

    @Test
    public void testLimitPushDown() {
        MaterializedResult actual = this.computeActual("(TABLE orders ORDER BY orderkey) UNION ALL SELECT * FROM orders WHERE orderstatus = 'F' UNION ALL (TABLE orders ORDER BY orderkey LIMIT 20) UNION ALL (TABLE orders LIMIT 5) UNION ALL TABLE orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT * FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
        this.assertQuery("SELECT name FROM nation ORDER BY nationkey LIMIT 3");
        this.assertQuery("SELECT name FROM nation ORDER BY regionkey LIMIT 5");
        this.assertQuery("SELECT max(regionkey) FROM nation LIMIT 5");
        this.assertQuery("SELECT regionkey, max(name) FROM nation GROUP BY regionkey LIMIT 5");
        this.assertQuery("SELECT DISTINCT regionkey FROM nation LIMIT 5");
        this.assertQuery("SELECT regionkey, count(*) FROM nation WHERE name < 'EGYPT' GROUP BY regionkey LIMIT 3");
    }

    @Test
    public void testScalarSubquery() {
        this.assertQuery("SELECT (SELECT (SELECT (SELECT 1)))");
        this.assertQuery("SELECT * FROM lineitem WHERE orderkey = \n(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT * FROM lineitem WHERE orderkey = \n(SELECT orderkey FROM orders WHERE 0=1)");
        this.assertQuery("SELECT * FROM lineitem WHERE \n(SELECT orderkey FROM orders WHERE 0=1) is null");
        this.assertQuery("SELECT * FROM lineitem WHERE \n(SELECT orderkey FROM orders WHERE 0=1) is not null");
        this.assertQuery("SELECT (SELECT 1) IN (1, 2, 3)");
        this.assertQuery("SELECT (SELECT 1) IN (   2, 3)");
        this.assertQuery("SELECT (SELECT 1) = (SELECT 3)");
        this.assertQuery("SELECT (SELECT 1) < (SELECT 3)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE (SELECT min(orderkey) FROM orders)<(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT (SELECT 1), (SELECT 2), (SELECT 3)");
        this.assertQuery("SELECT DISTINCT orderkey FROM lineitem WHERE orderkey BETWEEN   (SELECT avg(orderkey) FROM orders) - 10    AND   (SELECT avg(orderkey) FROM orders) + 10");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM orders o1 INNER JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o1 LEFT JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM orders o1 RIGHT JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT DISTINCT COUNT(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o1 FULL JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey", "VALUES 1, 10");
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY (SELECT 2)");
        String multipleRowsErrorMsg = "Scalar sub-query has returned multiple rows";
        this.assertQueryFails("SELECT * FROM lineitem WHERE orderkey = (\nSELECT orderkey FROM orders ORDER BY totalprice)", multipleRowsErrorMsg);
        this.assertQueryFails("SELECT orderkey, totalprice FROM orders ORDER BY (VALUES 1, 2)", multipleRowsErrorMsg);
        this.assertQuery("SELECT custkey, (SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 1) FROM orders");
        this.assertQuery("SELECT 1.0/(SELECT 1), CAST(1.0 AS REAL)/(SELECT 1), 1/(SELECT 1)");
        this.assertQuery("SELECT 1.0 = (SELECT 1) AND 1 = (SELECT 1), 2.0 = (SELECT 1) WHERE 1.0 = (SELECT 1) AND 1 = (SELECT 1)");
        this.assertQuery("SELECT 1.0 = (SELECT 1), 2.0 = (SELECT 1), CAST(2.0 AS REAL) = (SELECT 1) WHERE 1.0 = (SELECT 1)");
        this.assertQuery("SELECT * FROM (VALUES 1) t(a) WHERE 1=(SELECT count(*) WHERE 1.0 = a)", "SELECT 1");
        this.assertQuery("SELECT * FROM (VALUES 1.0) t(a) WHERE 1=(SELECT count(*) WHERE 1 = a)", "SELECT 1.0");
    }

    @Test
    public void testPredicatePushdown() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey+1 AS a FROM orders WHERE orderstatus = 'F' UNION ALL \n  SELECT orderkey FROM orders WHERE orderkey % 2 = 0 UNION ALL \n  (SELECT orderkey+custkey FROM orders ORDER BY orderkey LIMIT 10)\n) \nWHERE a < 20 OR a > 100 \nORDER BY a");
    }

    @Test
    public void testGroupByKeyPredicatePushdown() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey1, orderstatus1, SUM(totalprice1) totalprice, MAX(custkey2) maxcustkey\n  FROM (\n    SELECT *\n    FROM (\n      SELECT custkey custkey1, orderstatus orderstatus1, CAST(totalprice AS BIGINT) totalprice1, orderkey orderkey1\n      FROM orders\n    ) orders1 \n    JOIN (\n      SELECT custkey custkey2, orderstatus orderstatus2, CAST(totalprice AS BIGINT) totalprice2, orderkey orderkey2\n      FROM orders\n    ) orders2 ON orders1.orderkey1 = orders2.orderkey2\n  ) \n  GROUP BY custkey1, orderstatus1\n)\nWHERE custkey1 = maxcustkey\nAND maxcustkey % 2 = 0 \nAND orderstatus1 = 'F'\nAND totalprice > 10000\nORDER BY custkey1, orderstatus1, totalprice, maxcustkey");
    }

    @Test
    public void testNonDeterministicTableScanPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT *\n  FROM lineitem\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        org.testng.Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testNonDeterministicAggregationPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT orderkey, COUNT(*)\n  FROM lineitem\n  GROUP BY orderkey\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        org.testng.Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testUnionAllPredicateMoveAroundWithOverlappingProjections() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT orderkey AS x, orderkey AS y\n  FROM orders\n  WHERE orderkey % 3 = 0\n  UNION ALL\n  SELECT orderkey AS x, orderkey AS y\n  FROM orders\n  WHERE orderkey % 2 = 0\n) a\nJOIN (\n  SELECT orderkey AS x, orderkey AS y\n  FROM orders\n) b\nON a.x = b.x");
    }

    @Test
    public void testTableSampleBernoulliBoundaryValues() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (0)");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", fullSample.getTypes());
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testTableSampleBernoulli() {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        int total = this.computeExpected("SELECT orderkey FROM orders", (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT)).getMaterializedRows().size();
        for (int i = 0; i < 100; ++i) {
            List values = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (50)").getMaterializedRows();
            Assert.assertEquals((int)values.size(), (int)ImmutableSet.copyOf((Collection)values).size(), (String)"TABLESAMPLE produced duplicate rows");
            stats.addValue((double)values.size() * 1.0 / (double)total);
        }
        double mean = stats.getGeometricMean();
        org.testng.Assert.assertTrue((mean > 0.45 && mean < 0.55 ? 1 : 0) != 0, (String)String.format("Expected mean sampling rate to be ~0.5, but was %s", mean));
    }

    @Test
    public void testFilterPushdownWithAggregation() {
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE 0=1");
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE null");
    }

    @Test
    public void testCorrelatedJoin() {
        this.assertQuery("SELECT name FROM nation, LATERAL (SELECT 1 WHERE false)", "SELECT 1 WHERE false");
        this.assertQuery("SELECT name FROM nation, LATERAL (SELECT 1)", "SELECT name FROM nation");
        this.assertQuery("SELECT name FROM nation, LATERAL (SELECT 1 WHERE name = 'ola')", "SELECT 1 WHERE false");
        this.assertQuery("SELECT name FROM nation LEFT JOIN LATERAL (SELECT 1 WHERE name = 'ola') ON true", "SELECT name FROM nation");
        this.assertQuery("SELECT n FROM (VALUES 1) t(a), LATERAL (SELECT name FROM region) r(n)", "SELECT name FROM region");
        this.assertQuery("SELECT n FROM (SELECT 1 FROM (VALUES 1) WHERE rand() = 5) t(a) RIGHT JOIN LATERAL (SELECT name FROM region) r(n) ON true", "SELECT name FROM region");
        this.assertQuery("SELECT nationkey, a FROM nation, LATERAL (SELECT max(region.name) FROM region WHERE region.regionkey <= nation.regionkey) t(a) ORDER BY nationkey LIMIT 1", "VALUES (0, 'AFRICA')");
        this.assertQuery("SELECT nationkey, a FROM nation, LATERAL (SELECT region.name || '_' FROM region WHERE region.regionkey = nation.regionkey) t(a) ORDER BY nationkey LIMIT 1", "VALUES (0, 'AFRICA_')");
        this.assertQuery("SELECT nationkey, a, b, name FROM nation, LATERAL (SELECT nationkey + 2 AS a), LATERAL (SELECT a * -1 AS b) ORDER BY b LIMIT 1", "VALUES (24, 26, -26, 'UNITED STATES')");
        this.assertQuery("SELECT * FROM region r, LATERAL (SELECT * FROM nation) n WHERE n.regionkey = r.regionkey", "SELECT * FROM region, nation WHERE nation.regionkey = region.regionkey");
        this.assertQuery("SELECT * FROM region, LATERAL (SELECT * FROM nation WHERE nation.regionkey = region.regionkey)", "SELECT * FROM region, nation WHERE nation.regionkey = region.regionkey");
        this.assertQuery("SELECT quantity, extendedprice, avg_price, low, high FROM lineitem, LATERAL (SELECT extendedprice / quantity AS avg_price) average_price, LATERAL (SELECT avg_price * 0.9 AS low) lower_bound, LATERAL (SELECT avg_price * 1.1 AS high) upper_bound ORDER BY extendedprice, quantity LIMIT 1", "VALUES (1.0, 904.0, 904.0, 813.6, 994.400)");
        this.assertQuery("SELECT y FROM (VALUES array[2, 3]) a(x) CROSS JOIN LATERAL(SELECT x[1]) b(y)", "SELECT 2");
        this.assertQuery("SELECT * FROM (VALUES 2) a(x) CROSS JOIN LATERAL(SELECT x + 1)", "SELECT 2, 3");
        this.assertQuery("SELECT * FROM (VALUES 2) a(x) CROSS JOIN LATERAL(SELECT x)", "SELECT 2, 2");
        this.assertQuery("SELECT * FROM (VALUES 2) a(x) CROSS JOIN LATERAL(SELECT x, x + 1)", "SELECT 2, 2, 3");
        this.assertQuery("SELECT r.name, a FROM region r LEFT JOIN LATERAL (SELECT name FROM nation WHERE r.regionkey = nation.regionkey) n(a) ON r.name > a ORDER BY r.name LIMIT 1", "SELECT 'AFRICA', NULL");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) a(x) JOIN LATERAL(SELECT y FROM (VALUES 2, 3) b(y) WHERE y > x) c(z) ON z > 2*x", "VALUES (1, 3)");
        this.assertQuery("SELECT regionkey, n.name FROM region LEFT JOIN LATERAL (SELECT name FROM nation WHERE region.regionkey = regionkey ORDER BY nationkey LIMIT 2) n ON TRUE", "VALUES (0, 'ETHIOPIA'), (0, 'ALGERIA'), (1, 'BRAZIL'), (1, 'ARGENTINA'), (2, 'INDONESIA'), (2, 'INDIA'), (3, 'GERMANY'), (3, 'FRANCE'), (4, 'IRAN'), (4, 'EGYPT')");
    }

    @Test
    public void testPruningCountAggregationOverScalar() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT SUM(orderkey) FROM orders)");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT SUM(orderkey) FROM orders GROUP BY custkey)", "VALUES 1000");
        this.assertQuery("SELECT count(*) FROM (VALUES 2) t(a) GROUP BY a", "VALUES 1");
        this.assertQuery("SELECT a, count(*) FROM (VALUES 2) t(a) GROUP BY a", "VALUES (2, 1)");
        this.assertQuery("SELECT count(*) FROM (VALUES 2) t(a) GROUP BY a+1", "VALUES 1");
    }

    @Test
    public void testSubqueriesWithDisjunction() {
        List projections = QueryTemplate.parameter((String)"projection").of(new String[]{"count(*)", "*", "%condition%"});
        List conditions = QueryTemplate.parameter((String)"condition").of(new String[]{"nationkey IN (SELECT 1) OR TRUE", "EXISTS(SELECT 1) OR TRUE"});
        QueryTemplate.queryTemplate((String)"SELECT %projection% FROM nation WHERE %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{projections, conditions}).forEach(this::assertQuery);
        QueryTemplate.queryTemplate((String)"SELECT %projection% FROM nation WHERE (%condition%) AND nationkey <3", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{projections, conditions}).forEach(this::assertQuery);
        this.assertQuery("SELECT count(*) FROM nation WHERE (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) OR TRUE", "SELECT 25");
        this.assertQuery("SELECT (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) FROM nation WHERE (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) OR TRUE ORDER BY nationkey LIMIT 2", "VALUES true, null");
    }
}

