/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.airlift.discovery.server.testing.TestingDiscoveryServer;
import io.airlift.log.Logger;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.AllNodes;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.split.PageSourceManager;
import io.prestosql.split.SplitManager;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.sql.planner.Plan;
import io.prestosql.testing.AbstractTestQueries;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.ResultWithQueryId;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.testing.TestingGroupProvider;
import io.prestosql.testing.TestingPrestoClient;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.TransactionManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;

public class DistributedQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get(DistributedQueryRunner.class);
    private static final String ENVIRONMENT = "testing";
    private final TestingDiscoveryServer discoveryServer;
    private final TestingPrestoServer coordinator;
    private List<TestingPrestoServer> servers;
    private final Closer closer = Closer.create();
    private final TestingPrestoClient prestoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public static Builder builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private DistributedQueryRunner(Session defaultSession, int nodeCount, Map<String, String> extraProperties, Map<String, String> coordinatorProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, List<SystemAccessControl> systemAccessControls) throws Exception {
        long start;
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        try {
            start = System.nanoTime();
            this.discoveryServer = new TestingDiscoveryServer(environment);
            this.closer.register(() -> DistributedQueryRunner.closeUnchecked((AutoCloseable)this.discoveryServer));
            log.info("Created TestingDiscoveryServer in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
            ImmutableList.Builder servers = ImmutableList.builder();
            for (int i = 1; i < nodeCount; ++i) {
                TestingPrestoServer worker = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(this.discoveryServer.getBaseUrl(), false, extraProperties, environment, additionalModule, baseDataDir, systemAccessControls));
                servers.add((Object)worker);
            }
            HashMap<String, String> extraCoordinatorProperties = new HashMap<String, String>();
            extraCoordinatorProperties.putAll(extraProperties);
            extraCoordinatorProperties.putAll(coordinatorProperties);
            if (!extraCoordinatorProperties.containsKey("web-ui.authentication.type")) {
                extraCoordinatorProperties.put("web-ui.authentication.type", "fixed");
                extraCoordinatorProperties.put("web-ui.user", "admin");
            }
            this.coordinator = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(this.discoveryServer.getBaseUrl(), true, extraCoordinatorProperties, environment, additionalModule, baseDataDir, systemAccessControls));
            servers.add((Object)this.coordinator);
            this.servers = servers.build();
        }
        catch (Exception e) {
            try {
                throw this.closer.rethrow((Throwable)e, Exception.class);
            }
            catch (Throwable throwable) {
                this.closer.close();
                throw throwable;
            }
        }
        defaultSession = defaultSession.toSessionRepresentation().toSession(this.coordinator.getMetadata().getSessionPropertyManager(), defaultSession.getIdentity().getExtraCredentials());
        this.prestoClient = (TestingPrestoClient)this.closer.register((Closeable)new TestingPrestoClient(this.coordinator, defaultSession));
        this.waitForAllNodesGloballyVisible();
        start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        }
        log.info("Added functions in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        for (TestingPrestoServer server : this.servers) {
            this.addTestingCatalog(server);
        }
    }

    private static TestingPrestoServer createTestingPrestoServer(URI discoveryUri, boolean coordinator, Map<String, String> extraProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, List<SystemAccessControl> systemAccessControls) {
        long start = System.nanoTime();
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder().put((Object)"internal-communication.shared-secret", (Object)"test-secret").put((Object)"query.client.timeout", (Object)"10m").put((Object)"discovery.http-client.min-threads", (Object)"1").put((Object)"exchange.http-client.min-threads", (Object)"1").put((Object)"node-manager.http-client.min-threads", (Object)"1").put((Object)"exchange.page-buffer-client.max-callback-threads", (Object)"5").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"task.max-index-memory", (Object)"16kB").put((Object)"distributed-index-joins-enabled", (Object)"true");
        if (coordinator) {
            propertiesBuilder.put((Object)"node-scheduler.include-coordinator", (Object)"true");
            propertiesBuilder.put((Object)"join-distribution-type", (Object)"PARTITIONED");
            propertiesBuilder.put((Object)"failure-detector.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"memoryManager.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"scheduler.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"workerInfo.http-client.min-threads", (Object)"1");
        }
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)propertiesBuilder.build());
        properties.putAll(extraProperties);
        TestingPrestoServer server = TestingPrestoServer.builder().setCoordinator(coordinator).setProperties(properties).setEnvironment(environment).setDiscoveryUri(discoveryUri).setAdditionalModule(additionalModule).setBaseDataDir(baseDataDir).setSystemAccessControls(systemAccessControls).build();
        String nodeRole = coordinator ? "coordinator" : "worker";
        log.info("Created %s TestingPrestoServer in %s: %s", new Object[]{nodeRole, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit(), server.getBaseUrl()});
        return server;
    }

    public void addServers(int nodeCount) throws Exception {
        ImmutableList.Builder serverBuilder = new ImmutableList.Builder().addAll(this.servers);
        for (int i = 0; i < nodeCount; ++i) {
            TestingPrestoServer server = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(this.discoveryServer.getBaseUrl(), false, (Map<String, String>)ImmutableMap.of(), ENVIRONMENT, Modules.EMPTY_MODULE, Optional.empty(), (List<SystemAccessControl>)ImmutableList.of()));
            serverBuilder.add((Object)server);
            server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
            this.addTestingCatalog(server);
        }
        this.servers = serverBuilder.build();
        this.waitForAllNodesGloballyVisible();
    }

    private void waitForAllNodesGloballyVisible() throws InterruptedException {
        long start = System.nanoTime();
        while (!this.allNodesGloballyVisible()) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(10.0, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        log.info("Announced servers in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    private void addTestingCatalog(TestingPrestoServer server) {
        Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)"testing_catalog");
        server.getCatalogManager().registerCatalog(bogusTestingCatalog);
        SessionPropertyManager sessionPropertyManager = server.getMetadata().getSessionPropertyManager();
        sessionPropertyManager.addSystemSessionProperties(AbstractTestQueries.TEST_SYSTEM_PROPERTIES);
        sessionPropertyManager.addConnectorSessionProperties(bogusTestingCatalog.getConnectorCatalogName(), AbstractTestQueries.TEST_CATALOG_PROPERTIES);
    }

    private boolean allNodesGloballyVisible() {
        for (TestingPrestoServer server : this.servers) {
            AllNodes allNodes = server.refreshNodes();
            if (allNodes.getInactiveNodes().isEmpty() && allNodes.getActiveNodes().size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    public TestingPrestoClient getClient() {
        return this.prestoClient;
    }

    public int getNodeCount() {
        return this.servers.size();
    }

    public Session getDefaultSession() {
        return this.prestoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.coordinator.getTransactionManager();
    }

    public Metadata getMetadata() {
        return this.coordinator.getMetadata();
    }

    public SplitManager getSplitManager() {
        return this.coordinator.getSplitManager();
    }

    public PageSourceManager getPageSourceManager() {
        return this.coordinator.getPageSourceManager();
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.coordinator.getNodePartitioningManager();
    }

    public StatsCalculator getStatsCalculator() {
        return this.coordinator.getStatsCalculator();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.coordinator.getAccessControl();
    }

    public TestingGroupProvider getGroupProvider() {
        return this.coordinator.getGroupProvider();
    }

    public TestingPrestoServer getCoordinator() {
        return this.coordinator;
    }

    public List<TestingPrestoServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    public void installPlugin(Plugin plugin) {
        long start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.installPlugin(plugin);
        }
        log.info("Installed plugin %s in %s", new Object[]{plugin.getClass().getSimpleName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public void addFunctions(List<? extends SqlFunction> functions) {
        this.servers.forEach(server -> server.getMetadata().addFunctions(functions));
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        long start = System.nanoTime();
        HashSet<CatalogName> catalogNames = new HashSet<CatalogName>();
        for (TestingPrestoServer server : this.servers) {
            catalogNames.add(server.createCatalog(catalogName, connectorName, properties));
        }
        CatalogName catalog = (CatalogName)Iterables.getOnlyElement(catalogNames);
        log.info("Created catalog %s (%s) in %s", new Object[]{catalogName, catalog, Duration.nanosSince((long)start)});
        start = System.nanoTime();
        while (!this.isConnectionVisibleToAllNodes(catalog)) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(100.0, TimeUnit.SECONDS), (String)("waiting for connector " + catalog + " to be initialized in every node"));
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        log.info("Announced catalog %s (%s) in %s", new Object[]{catalogName, catalog, Duration.nanosSince((long)start)});
    }

    private boolean isConnectionVisibleToAllNodes(CatalogName catalogName) {
        for (TestingPrestoServer server : this.servers) {
            server.refreshNodes();
            Set activeNodesWithConnector = server.getActiveNodesWithConnector(catalogName);
            if (activeNodesWithConnector.size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.prestoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.prestoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(session, sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWithQueryId<MaterializedResult> executeWithQueryId(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            ResultWithQueryId<MaterializedResult> resultWithQueryId = this.prestoClient.execute(session, sql);
            return resultWithQueryId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql, WarningCollector warningCollector) {
        ResultWithQueryId<MaterializedResult> resultWithQueryId = this.executeWithQueryId(session, sql);
        return new QueryRunner.MaterializedResultWithPlan(resultWithQueryId.getResult().toTestTypes(), this.getQueryPlan(resultWithQueryId.getQueryId()));
    }

    public Plan createPlan(Session session, String sql, WarningCollector warningCollector) {
        QueryId queryId = this.executeWithQueryId(session, sql).getQueryId();
        Plan queryPlan = this.getQueryPlan(queryId);
        this.coordinator.getQueryManager().cancelQuery(queryId);
        return queryPlan;
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.coordinator.getQueryPlan(queryId);
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public final void close() {
        this.cancelAllQueries();
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void cancelAllQueries() {
        QueryManager queryManager = this.coordinator.getQueryManager();
        for (BasicQueryInfo queryInfo : queryManager.getQueries()) {
            if (queryInfo.getState().isDone()) continue;
            queryManager.cancelQuery(queryInfo.getQueryId());
        }
    }

    private static void closeUnchecked(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private Session defaultSession;
        private int nodeCount = 3;
        private Map<String, String> extraProperties = new HashMap<String, String>();
        private Map<String, String> coordinatorProperties = ImmutableMap.of();
        private String environment = "testing";
        private Module additionalModule = Modules.EMPTY_MODULE;
        private Optional<Path> baseDataDir = Optional.empty();
        private List<SystemAccessControl> systemAccessControls = ImmutableList.of();

        protected Builder(Session defaultSession) {
            this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        }

        public Builder amendSession(Function<Session.SessionBuilder, Session.SessionBuilder> amendSession) {
            Session.SessionBuilder builder = Session.builder((Session)this.defaultSession);
            this.defaultSession = amendSession.apply(builder).build();
            return this;
        }

        public Builder setNodeCount(int nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public Builder setExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = new HashMap<String, String>(extraProperties);
            return this;
        }

        public Builder addExtraProperty(String key, String value) {
            this.extraProperties.put(key, value);
            return this;
        }

        public Builder setCoordinatorProperties(Map<String, String> coordinatorProperties) {
            this.coordinatorProperties = coordinatorProperties;
            return this;
        }

        public Builder setSingleCoordinatorProperty(String key, String value) {
            return this.setCoordinatorProperties((Map<String, String>)ImmutableMap.of((Object)key, (Object)value));
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setAdditionalModule(Module additionalModule) {
            this.additionalModule = Objects.requireNonNull(additionalModule, "additionalModules is null");
            return this;
        }

        public Builder setBaseDataDir(Optional<Path> baseDataDir) {
            this.baseDataDir = Objects.requireNonNull(baseDataDir, "baseDataDir is null");
            return this;
        }

        public Builder setSystemAccessControl(SystemAccessControl systemAccessControl) {
            return this.setSystemAccessControls((List<SystemAccessControl>)ImmutableList.of((Object)Objects.requireNonNull(systemAccessControl, "systemAccessControl is null")));
        }

        public Builder setSystemAccessControls(List<SystemAccessControl> systemAccessControls) {
            this.systemAccessControls = ImmutableList.copyOf((Collection)Objects.requireNonNull(systemAccessControls, "systemAccessControls is null"));
            return this;
        }

        public DistributedQueryRunner build() throws Exception {
            return new DistributedQueryRunner(this.defaultSession, this.nodeCount, this.extraProperties, this.coordinatorProperties, this.environment, this.additionalModule, this.baseDataDir, this.systemAccessControls);
        }
    }
}

