/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.util.Reflection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class StatefulSleepingSum
extends SqlScalarFunction {
    public static final StatefulSleepingSum STATEFUL_SLEEPING_SUM = new StatefulSleepingSum();

    private StatefulSleepingSum() {
        super(new FunctionMetadata(new Signature("stateful_sleeping_sum", (List)ImmutableList.of((Object)Signature.typeVariable((String)"bigint")), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature()), false), false, (List)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), true, true, "testing not thread safe function", FunctionKind.SCALAR));
    }

    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        int args = 4;
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(args, InvocationConvention.InvocationArgumentConvention.NEVER_NULL), Reflection.methodHandle(StatefulSleepingSum.class, (String)"statefulSleepingSum", (Class[])new Class[]{State.class, Double.TYPE, Long.TYPE, Long.TYPE, Long.TYPE}), Optional.of(Reflection.constructorMethodHandle(State.class, (Class[])new Class[0])));
    }

    public static long statefulSleepingSum(State state, double sleepProbability, long sleepDurationMillis, long a, long b) {
        int currentThreads = state.currentThreads.incrementAndGet();
        try {
            Preconditions.checkState((currentThreads == 1 ? 1 : 0) != 0, (String)"%s threads concurrently executing a stateful function", (int)currentThreads);
            if (ThreadLocalRandom.current().nextDouble() < sleepProbability) {
                Thread.sleep(sleepDurationMillis);
            }
            long l = a + b;
            return l;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted", e);
        }
        finally {
            state.currentThreads.decrementAndGet();
        }
    }

    public static class State {
        private final AtomicInteger currentThreads = new AtomicInteger();
    }
}

