/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.server.SessionContext;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.session.ResourceEstimates;
import io.prestosql.transaction.TransactionId;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TestingSessionContext
implements SessionContext {
    private final Session session;

    public TestingSessionContext(Session session) {
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public Optional<Identity> getAuthenticatedIdentity() {
        return Optional.empty();
    }

    public Identity getIdentity() {
        return this.session.getIdentity();
    }

    public String getCatalog() {
        return this.session.getCatalog().orElse(null);
    }

    public String getSchema() {
        return this.session.getSchema().orElse(null);
    }

    public String getPath() {
        return this.session.getPath().toString();
    }

    public String getSource() {
        return this.session.getSource().orElse(null);
    }

    public Optional<String> getTraceToken() {
        return this.session.getTraceToken();
    }

    public String getRemoteUserAddress() {
        return this.session.getRemoteUserAddress().orElse(null);
    }

    public String getUserAgent() {
        return this.session.getUserAgent().orElse(null);
    }

    public String getClientInfo() {
        return this.session.getClientInfo().orElse(null);
    }

    public Set<String> getClientTags() {
        return this.session.getClientTags();
    }

    public Set<String> getClientCapabilities() {
        return this.session.getClientCapabilities();
    }

    public ResourceEstimates getResourceEstimates() {
        return this.session.getResourceEstimates();
    }

    public String getTimeZoneId() {
        return this.session.getTimeZoneKey().getId();
    }

    public String getLanguage() {
        return this.session.getLocale().getLanguage();
    }

    public Map<String, String> getSystemProperties() {
        return this.session.getSystemProperties();
    }

    public Map<String, Map<String, String>> getCatalogSessionProperties() {
        ImmutableMap.Builder catalogSessionProperties = ImmutableMap.builder();
        for (Map.Entry entry : this.session.getConnectorProperties().entrySet()) {
            catalogSessionProperties.put((Object)((CatalogName)entry.getKey()).getCatalogName(), (Object)((Map)entry.getValue()));
        }
        return catalogSessionProperties.build();
    }

    public Map<String, String> getPreparedStatements() {
        return this.session.getPreparedStatements();
    }

    public Optional<TransactionId> getTransactionId() {
        return this.session.getTransactionId();
    }

    public boolean supportClientTransaction() {
        return this.session.isClientTransactionSupport();
    }
}

