/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.datatype;

import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.datatype.DataType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class DataTypeTestToSqlDataTypeTestConverter {
    private StringBuilder output = new StringBuilder();

    public static DataTypeTestToSqlDataTypeTestConverter create() {
        return new DataTypeTestToSqlDataTypeTestConverter();
    }

    private DataTypeTestToSqlDataTypeTestConverter() {
        this.output.append("SqlDataTypeTest.create()\n");
    }

    public <T> DataTypeTestToSqlDataTypeTestConverter addRoundTrip(DataType<T> dataType, T value) {
        this.output.append(String.format(" .addRoundTrip(%s, %s, %s, %s)", DataTypeTestToSqlDataTypeTestConverter.toJavaLiteral(dataType.getInsertType()), DataTypeTestToSqlDataTypeTestConverter.toJavaLiteral(dataType.toLiteral(value)), this.typeConstructor(dataType.getPrestoResultType()), DataTypeTestToSqlDataTypeTestConverter.toJavaLiteral(dataType.toPrestoLiteral(value))));
        Object expected = dataType.toPrestoQueryResult(value);
        if (expected != value) {
            this.output.append(String.format(" // TODO non-identity toPrestoQueryResult function was used: %s vs %s", value, expected));
        }
        this.output.append("\n");
        return this;
    }

    private String typeConstructor(Type type) {
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return String.format("createDecimalType(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
        }
        if (type instanceof CharType) {
            return String.format("createCharType(%s)", ((CharType)type).getLength());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return "createUnboundedVarcharType()";
            }
            return String.format("createVarcharType(%s)", varcharType.getBoundedLength());
        }
        if (type instanceof TimeType) {
            return String.format("createTimeType(%s)", ((TimeType)type).getPrecision());
        }
        if (type instanceof TimeWithTimeZoneType) {
            return String.format("createTimeWithTimeZoneType(%s)", ((TimeWithTimeZoneType)type).getPrecision());
        }
        if (type instanceof TimestampType) {
            return String.format("createTimestampType(%s)", ((TimestampType)type).getPrecision());
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return String.format("createTimestampWithTimeZoneType(%s)", ((TimestampWithTimeZoneType)type).getPrecision());
        }
        try {
            for (Field field : type.getClass().getFields()) {
                if (!field.getName().matches("^[A-Z_]+$") || !Modifier.isStatic(field.getModifiers()) || field.get(null) != type) continue;
                return field.getName();
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return type.getDisplayName();
    }

    public DataTypeTestToSqlDataTypeTestConverter execute(Object ... args) {
        this.output.append(" .execute( ... ) // TODO\n");
        throw new RuntimeException("Code replacement:\n" + this.output);
    }

    private static String toJavaLiteral(String value) {
        if (value.contains("\\") || value.contains("\"") || value.contains("\n")) {
            throw new IllegalArgumentException(String.format("Unsupported value: [%s]", value));
        }
        return String.format("\"%s\"", value);
    }
}

