/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.testing.sql.SqlExecutor;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class TestTable
implements AutoCloseable {
    private static final SecureRandom random = new SecureRandom();
    private static final int RANDOM_SUFFIX_LENGTH = 5;
    private final SqlExecutor sqlExecutor;
    private final String name;

    public TestTable(SqlExecutor sqlExecutor, String namePrefix, String tableDefinition) {
        this(sqlExecutor, namePrefix, tableDefinition, (List<String>)ImmutableList.of());
    }

    public TestTable(SqlExecutor sqlExecutor, String namePrefix, String tableDefinition, List<String> rowsToInsert) {
        this.sqlExecutor = sqlExecutor;
        this.name = namePrefix + "_" + TestTable.randomTableSuffix();
        sqlExecutor.execute(String.format("CREATE TABLE %s %s", this.name, tableDefinition));
        try {
            for (String row : rowsToInsert) {
                sqlExecutor.execute(String.format("INSERT INTO %s VALUES (%s)", this.name, row));
            }
        }
        catch (Exception e) {
            TestTable ignored = this;
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public static TestTable fromColumns(SqlExecutor sqlExecutor, String namePrefix, Map<String, List<String>> columns) {
        return TestTable.fromColumns(sqlExecutor, namePrefix, columns, (String column) -> {
            throw new IllegalArgumentException(String.format("Some values missing for column '%s'", column));
        });
    }

    public static TestTable fromColumns(SqlExecutor sqlExecutor, String namePrefix, Map<String, List<String>> columns, String defaultValue) {
        return TestTable.fromColumns(sqlExecutor, namePrefix, columns, (String column) -> defaultValue);
    }

    private static TestTable fromColumns(SqlExecutor sqlExecutor, String namePrefix, Map<String, List<String>> columns, Function<String, String> defaultValueSupplier) {
        int rowsCount = columns.values().stream().mapToInt(List::size).max().orElseThrow(() -> new IllegalArgumentException("please, give me at least one column to work with"));
        return TestTable.fromColumnValueProviders(sqlExecutor, namePrefix, rowsCount, (Map)columns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> index -> {
            if (index < ((List)entry.getValue()).size()) {
                return (String)((List)entry.getValue()).get((int)index);
            }
            return (String)defaultValueSupplier.apply((String)entry.getKey());
        })));
    }

    public static TestTable fromColumnValueProviders(SqlExecutor sqlExecutor, String namePrefix, int rowsCount, Map<String, Function<Integer, String>> columnsValueProviders) {
        String tableDefinition = "(" + String.join((CharSequence)",", columnsValueProviders.keySet()) + ")";
        ImmutableList.Builder rows = ImmutableList.builder();
        for (int rowId = 0; rowId < rowsCount; ++rowId) {
            ImmutableList.Builder rowValues = ImmutableList.builder();
            for (Function<Integer, String> columnValues : columnsValueProviders.values()) {
                rowValues.add((Object)columnValues.apply(rowId));
            }
            rows.add((Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)rowValues.build()));
        }
        return new TestTable(sqlExecutor, namePrefix, tableDefinition, (List<String>)rows.build());
    }

    @Override
    public void close() {
        this.sqlExecutor.execute("DROP TABLE " + this.name);
    }

    public static String randomTableSuffix() {
        String randomSuffix = Long.toString(Math.abs(random.nextLong()), 36);
        return randomSuffix.substring(0, Math.min(5, randomSuffix.length()));
    }
}

