/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.statistics;

import com.google.common.base.Preconditions;
import io.prestosql.testing.statistics.Metric;
import io.prestosql.testing.statistics.MetricComparisonStrategy;
import java.util.Objects;
import java.util.OptionalDouble;

public class MetricComparison {
    private final Metric metric;
    private final OptionalDouble estimatedValue;
    private final OptionalDouble actualValue;

    public MetricComparison(Metric metric, OptionalDouble estimatedValue, OptionalDouble actualValue) {
        this.metric = metric;
        this.estimatedValue = estimatedValue;
        this.actualValue = actualValue;
    }

    public String toString() {
        return String.format("Metric [%s] - estimated: [%s], real: [%s]", this.metric, this.print(this.estimatedValue), this.print(this.actualValue));
    }

    public Result result(MetricComparisonStrategy metricComparisonStrategy) {
        Objects.requireNonNull(metricComparisonStrategy, "metricComparisonStrategy is null");
        if (this.estimatedValue.isEmpty() && this.actualValue.isEmpty()) {
            return Result.MATCH;
        }
        if (this.estimatedValue.isEmpty()) {
            return Result.NO_ESTIMATE;
        }
        Preconditions.checkState((boolean)this.actualValue.isPresent(), (Object)"actual value is not present");
        return metricComparisonStrategy.matches(this.actualValue.getAsDouble(), this.estimatedValue.getAsDouble()) ? Result.MATCH : Result.DIFFER;
    }

    private String print(OptionalDouble value) {
        if (value.isEmpty()) {
            return "UNKNOWN";
        }
        return String.valueOf(value.getAsDouble());
    }

    public static enum Result {
        NO_ESTIMATE,
        DIFFER,
        MATCH;

    }
}

