/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testng.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.prestosql.testng.services.Flaky;
import io.prestosql.testng.services.Listeners;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.testng.IClassListener;
import org.testng.ITestClass;
import org.testng.annotations.Test;

public class FlakyAnnotationVerifier
implements IClassListener {
    public void onBeforeClass(ITestClass testClass) {
        try {
            this.reportMethodsWithFlakyAndNoTestAnnotation(testClass);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(FlakyAnnotationVerifier.class, "Failed to process %s: \n%s", testClass, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void reportMethodsWithFlakyAndNoTestAnnotation(ITestClass testClass) {
        Class realClass = testClass.getRealClass();
        if (realClass.getSuperclass() != null && "io.prestosql.tempto.internal.convention.ConventionBasedTestProxyGenerator$ConventionBasedTestProxy".equals(realClass.getSuperclass().getName())) {
            return;
        }
        if (realClass.getName().startsWith("io.prestosql.testng.services.TestFlakyAnnotationVerifier")) {
            return;
        }
        List<Method> unannotatedTestMethods = FlakyAnnotationVerifier.findMethodsWithFlakyAndNoTestAnnotation(realClass);
        if (!unannotatedTestMethods.isEmpty()) {
            Listeners.reportListenerFailure(FlakyAnnotationVerifier.class, "Test class %s has methods which are marked as @Flaky but are not explicitly annotated with @Test:%s", realClass.getName(), unannotatedTestMethods.stream().map(Method::toString).collect(Collectors.joining("\n\t\t", "\n\t\t", "")));
        }
        FlakyAnnotationVerifier.verifyFlakyAnnotations(realClass).ifPresent(error -> Listeners.reportListenerFailure(FlakyAnnotationVerifier.class, "%s", error));
    }

    @VisibleForTesting
    static Optional<String> verifyFlakyAnnotations(Class<?> realClass) {
        for (Method method : realClass.getMethods()) {
            Optional<Flaky> flaky = FlakyAnnotationVerifier.findInheritableAnnotation(method, Flaky.class);
            if (flaky.isEmpty()) continue;
            if (flaky.get().issue().isBlank()) {
                return Optional.of(String.format("Test method %s has empty @Flaky.issue", method));
            }
            try {
                Pattern.compile(flaky.get().match());
            }
            catch (PatternSyntaxException e) {
                return Optional.of(String.format("Test method %s has invalid @Flaky.match: %s", method, Throwables.getStackTraceAsString((Throwable)e)));
            }
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static List<Method> findMethodsWithFlakyAndNoTestAnnotation(Class<?> realClass) {
        return (List)Arrays.stream(realClass.getMethods()).filter(method -> FlakyAnnotationVerifier.findInheritableAnnotation(method, Flaky.class).isPresent()).filter(method -> !method.isAnnotationPresent(Test.class)).collect(ImmutableList.toImmutableList());
    }

    public void onAfterClass(ITestClass testClass) {
    }

    private static <T extends Annotation> Optional<T> findInheritableAnnotation(Method method, Class<T> annotationClass) {
        while (method != null) {
            T annotation = method.getAnnotation(annotationClass);
            if (annotation != null) {
                return Optional.of(annotation);
            }
            method = FlakyAnnotationVerifier.getSuperMethod(method).orElse(null);
        }
        return Optional.empty();
    }

    private static Optional<Method> getSuperMethod(Method method) {
        try {
            Class<?> superclass = method.getDeclaringClass().getSuperclass();
            if (superclass == null) {
                return Optional.empty();
            }
            return Optional.of(superclass.getMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }
}

