/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests;

import io.prestosql.operator.aggregation.state.NullableLongState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;

@AggregationFunction(value="custom_sum")
public final class CustomSum {
    private CustomSum() {
    }

    @InputFunction
    public static void input(@AggregationState NullableLongState state, @SqlType(value="bigint") long value) {
        state.setLong(state.getLong() + value);
        state.setNull(false);
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(otherState.getLong());
            return;
        }
        state.setLong(state.getLong() + otherState.getLong());
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, (NullableLongState)state, (BlockBuilder)out);
    }
}

