/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.datatype;

import com.google.common.base.Joiner;
import io.prestosql.tests.datatype.DataSetup;
import io.prestosql.tests.datatype.DataTypeTest;
import io.prestosql.tests.sql.SqlExecutor;
import io.prestosql.tests.sql.TestTable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class CreateAndInsertDataSetup
implements DataSetup {
    private final SqlExecutor sqlExecutor;
    private final String tableNamePrefix;

    public CreateAndInsertDataSetup(SqlExecutor sqlExecutor, String tableNamePrefix) {
        this.sqlExecutor = sqlExecutor;
        this.tableNamePrefix = tableNamePrefix;
    }

    @Override
    public TestTable setupTestTable(List<DataTypeTest.Input<?>> inputs) {
        TestTable testTable = this.createTestTable(inputs);
        try {
            this.insertRows(testTable, inputs);
        }
        catch (Exception e) {
            testTable.close();
            throw e;
        }
        return testTable;
    }

    private void insertRows(TestTable testTable, List<DataTypeTest.Input<?>> inputs) {
        Stream<String> literals = inputs.stream().map(DataTypeTest.Input::toLiteral);
        String valueLiterals = Joiner.on((String)", ").join(literals.iterator());
        this.sqlExecutor.execute(String.format("INSERT INTO %s VALUES(%s)", testTable.getName(), valueLiterals));
    }

    private TestTable createTestTable(List<DataTypeTest.Input<?>> inputs) {
        String ddlTemplate = "CREATE TABLE {TABLE_NAME} (\n" + this.columnDefinitions(inputs) + "\n)";
        return new TestTable(this.sqlExecutor, this.tableNamePrefix, ddlTemplate);
    }

    private String columnDefinitions(List<DataTypeTest.Input<?>> inputs) {
        List columnTypeDefinitions = inputs.stream().map(DataTypeTest.Input::getInsertType).collect(Collectors.toList());
        Stream<String> columnDefinitions = IntStream.range(0, columnTypeDefinitions.size()).mapToObj(i -> String.format("col_%d %s", i, columnTypeDefinitions.get(i)));
        return Joiner.on((String)",\n").join(columnDefinitions.iterator());
    }
}

