/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.datatype;

import com.google.common.base.Joiner;
import io.prestosql.tests.datatype.DataSetup;
import io.prestosql.tests.datatype.DataTypeTest;
import io.prestosql.tests.sql.SqlExecutor;
import io.prestosql.tests.sql.TestTable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class CreateAsSelectDataSetup
implements DataSetup {
    private final SqlExecutor sqlExecutor;
    private final String tableNamePrefix;

    public CreateAsSelectDataSetup(SqlExecutor sqlExecutor, String tableNamePrefix) {
        this.sqlExecutor = sqlExecutor;
        this.tableNamePrefix = tableNamePrefix;
    }

    @Override
    public TestTable setupTestTable(List<DataTypeTest.Input<?>> inputs) {
        List columnValues = inputs.stream().map(this::literalInExplicitCast).collect(Collectors.toList());
        Stream<String> columnValuesWithNames = IntStream.range(0, columnValues.size()).mapToObj(i -> String.format("%s col_%d", columnValues.get(i), i));
        String selectBody = Joiner.on((String)",\n").join(columnValuesWithNames.iterator());
        String ddlTemplate = "CREATE TABLE {TABLE_NAME} AS SELECT\n" + selectBody;
        return new TestTable(this.sqlExecutor, this.tableNamePrefix, ddlTemplate);
    }

    private String literalInExplicitCast(DataTypeTest.Input<?> input) {
        return String.format("CAST(%s AS %s)", input.toLiteral(), input.getInsertType());
    }
}

