/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.statistics;

import io.prestosql.tests.statistics.Metric;
import io.prestosql.tests.statistics.MetricComparisonStrategy;
import java.util.Objects;
import java.util.OptionalDouble;

public class MetricComparison {
    private final Metric metric;
    private final OptionalDouble estimatedValue;
    private final OptionalDouble actualValue;

    public MetricComparison(Metric metric, OptionalDouble estimatedValue, OptionalDouble actualValue) {
        this.metric = metric;
        this.estimatedValue = estimatedValue;
        this.actualValue = actualValue;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public String toString() {
        return String.format("Metric [%s] - estimated: [%s], real: [%s]", this.metric, this.print(this.estimatedValue), this.print(this.actualValue));
    }

    public Result result(MetricComparisonStrategy metricComparisonStrategy) {
        Objects.requireNonNull(metricComparisonStrategy, "metricComparisonStrategy is null");
        if (!this.estimatedValue.isPresent() && !this.actualValue.isPresent()) {
            return Result.MATCH;
        }
        if (!this.estimatedValue.isPresent()) {
            return Result.NO_ESTIMATE;
        }
        if (!this.actualValue.isPresent()) {
            return Result.NO_BASELINE;
        }
        return metricComparisonStrategy.matches(this.actualValue.getAsDouble(), this.estimatedValue.getAsDouble()) ? Result.MATCH : Result.DIFFER;
    }

    private String print(OptionalDouble value) {
        if (!value.isPresent()) {
            return "UNKNOWN";
        }
        return String.valueOf(value.getAsDouble());
    }

    public static enum Result {
        NO_ESTIMATE,
        NO_BASELINE,
        DIFFER,
        MATCH;

    }
}

