/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.statistics;

import com.google.common.base.Preconditions;
import io.prestosql.tests.statistics.MetricComparisonStrategy;

public final class MetricComparisonStrategies {
    private MetricComparisonStrategies() {
    }

    public static MetricComparisonStrategy noError() {
        return MetricComparisonStrategies.absoluteError(0.0);
    }

    public static MetricComparisonStrategy absoluteError(double error) {
        return MetricComparisonStrategies.absoluteError(-error, error);
    }

    public static MetricComparisonStrategy absoluteError(double minError, double maxError) {
        Preconditions.checkArgument((minError <= maxError ? 1 : 0) != 0, (String)"minError '%s' has to be lower or equal than maxError '%s'", (Object)minError, (Object)maxError);
        return (actual, estimate) -> {
            double minEstimateValue = actual + minError;
            double maxEstimateValue = actual + maxError;
            return estimate >= minEstimateValue && estimate <= maxEstimateValue;
        };
    }

    public static MetricComparisonStrategy defaultTolerance() {
        return MetricComparisonStrategies.relativeError(0.1);
    }

    public static MetricComparisonStrategy relativeError(double error) {
        return MetricComparisonStrategies.relativeError(-error, error);
    }

    public static MetricComparisonStrategy relativeError(double minError, double maxError) {
        Preconditions.checkArgument((minError <= maxError ? 1 : 0) != 0, (String)"minError '%s' has to be lower or equal than maxError '%s'", (Object)minError, (Object)maxError);
        return (actual, estimate) -> {
            double minEstimateValue = actual * (minError + 1.0);
            double maxEstimateValue = actual * (maxError + 1.0);
            return estimate >= minEstimateValue && estimate <= maxEstimateValue;
        };
    }
}

