/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.tpch;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.tpch.TpchNodePartitioningProvider;
import io.prestosql.plugin.tpch.TpchRecordSetProvider;
import io.prestosql.plugin.tpch.TpchSplitManager;
import io.prestosql.plugin.tpch.TpchTransactionHandle;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorIndexProvider;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.transaction.IsolationLevel;
import io.prestosql.tests.tpch.ExampleSystemTable;
import io.prestosql.tests.tpch.TpchIndexHandleResolver;
import io.prestosql.tests.tpch.TpchIndexMetadata;
import io.prestosql.tests.tpch.TpchIndexProvider;
import io.prestosql.tests.tpch.TpchIndexSpec;
import io.prestosql.tests.tpch.TpchIndexedData;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IndexedTpchConnectorFactory
implements ConnectorFactory {
    private final TpchIndexSpec indexSpec;
    private final int defaultSplitsPerNode;

    public IndexedTpchConnectorFactory(TpchIndexSpec indexSpec, int defaultSplitsPerNode) {
        this.indexSpec = Objects.requireNonNull(indexSpec, "indexSpec is null");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
    }

    public String getName() {
        return "tpch_indexed";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpchIndexHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> properties, ConnectorContext context) {
        final int splitsPerNode = this.getSplitsPerNode(properties);
        final TpchIndexedData indexedData = new TpchIndexedData(this.indexSpec);
        final NodeManager nodeManager = context.getNodeManager();
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return TpchTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
                return new TpchIndexMetadata(indexedData);
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(nodeManager, splitsPerNode);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpchRecordSetProvider();
            }

            public ConnectorIndexProvider getIndexProvider() {
                return new TpchIndexProvider(indexedData);
            }

            public Set<SystemTable> getSystemTables() {
                return ImmutableSet.of((Object)new ExampleSystemTable());
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpchNodePartitioningProvider(nodeManager, splitsPerNode);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }
}

