/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.tpch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TpchSplit
implements ConnectorSplit {
    private final int totalParts;
    private final int partNumber;
    private final List<HostAddress> addresses;

    @JsonCreator
    public TpchSplit(@JsonProperty(value="partNumber") int partNumber, @JsonProperty(value="totalParts") int totalParts, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        Preconditions.checkState((partNumber >= 0 ? 1 : 0) != 0, (Object)"partNumber must be >= 0");
        Preconditions.checkState((totalParts >= 1 ? 1 : 0) != 0, (Object)"totalParts must be >= 1");
        Preconditions.checkState((totalParts > partNumber ? 1 : 0) != 0, (Object)"totalParts must be > partNumber");
        this.partNumber = partNumber;
        this.totalParts = totalParts;
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
    }

    @JsonProperty
    public int getTotalParts() {
        return this.totalParts;
    }

    @JsonProperty
    public int getPartNumber() {
        return this.partNumber;
    }

    public Object getInfo() {
        return this;
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TpchSplit other = (TpchSplit)obj;
        return Objects.equals(this.totalParts, other.totalParts) && Objects.equals(this.partNumber, other.partNumber);
    }

    public int hashCode() {
        return Objects.hash(this.totalParts, this.partNumber);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partNumber", this.partNumber).add("totalParts", this.totalParts).toString();
    }
}

