/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.tpch.TpchSplit;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.Node;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.Set;

public class TpchSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;
    private final int splitsPerNode;

    public TpchSplitManager(NodeManager nodeManager, int splitsPerNode) {
        this.nodeManager = nodeManager;
        Preconditions.checkArgument((splitsPerNode > 0 ? 1 : 0) != 0, (Object)"splitsPerNode must be at least 1");
        this.splitsPerNode = splitsPerNode;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        int totalParts = nodes.size() * this.splitsPerNode;
        int partNumber = 0;
        ImmutableList.Builder splits = ImmutableList.builder();
        for (Node node : nodes) {
            for (int i = 0; i < this.splitsPerNode; ++i) {
                splits.add((Object)new TpchSplit(partNumber, totalParts, (List<HostAddress>)ImmutableList.of((Object)node.getHostAndPort())));
                ++partNumber;
            }
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

