/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.tpch.util;

import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.function.Predicate;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static Predicate<NullableValue> convertToPredicate(TupleDomain<ColumnHandle> predicate, TpchColumnHandle columnHandle) {
        TupleDomain<ColumnHandle> columnPredicate = PredicateUtils.filterColumns(predicate, columnHandle::equals);
        return nullableValue -> columnPredicate.contains(TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)nullableValue)));
    }

    public static TupleDomain<ColumnHandle> filterOutColumnFromPredicate(TupleDomain<ColumnHandle> predicate, TpchColumnHandle columnHandle) {
        return PredicateUtils.filterColumns(predicate, tpchColumnHandle -> !tpchColumnHandle.equals(columnHandle));
    }

    public static TupleDomain<ColumnHandle> filterColumns(TupleDomain<ColumnHandle> predicate, Predicate<TpchColumnHandle> filterPredicate) {
        return predicate.transform(columnHandle -> {
            TpchColumnHandle tpchColumnHandle = (TpchColumnHandle)columnHandle;
            if (filterPredicate.test(tpchColumnHandle)) {
                return tpchColumnHandle;
            }
            return null;
        });
    }
}

