/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.tpch.statistics;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.prestosql.plugin.tpch.statistics.TableStatisticsData;
import io.prestosql.plugin.tpch.util.Optionals;
import io.prestosql.tpch.TpchColumn;
import io.prestosql.tpch.TpchTable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class TableStatisticsDataRepository {
    private final ObjectMapper objectMapper;

    public TableStatisticsDataRepository(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void save(String schemaName, TpchTable<?> table, Optional<TpchColumn<?>> partitionColumn, Optional<String> partitionValue, TableStatisticsData statisticsData) {
        String filename = this.tableStatisticsDataFilename(table, partitionColumn, partitionValue);
        Path path = Paths.get("presto-tpch", "src", "main", "resources", "tpch", "statistics", schemaName, filename + ".json");
        this.writeStatistics(path, statisticsData);
    }

    private void writeStatistics(Path path, TableStatisticsData tableStatisticsData) {
        File file = path.toFile();
        file.getParentFile().mkdirs();
        try {
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)tableStatisticsData);
            try (FileWriter fileWriter = new FileWriter(file, true);){
                fileWriter.append('\n');
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save table statistics data", e);
        }
    }

    public Optional<TableStatisticsData> load(String schemaName, TpchTable<?> table, Optional<TpchColumn<?>> partitionColumn, Optional<String> partitionValue) {
        String filename = this.tableStatisticsDataFilename(table, partitionColumn, partitionValue);
        String resourcePath = "/tpch/statistics/" + schemaName + "/" + filename + ".json";
        URL resource = this.getClass().getResource(resourcePath);
        if (resource == null) {
            return Optional.empty();
        }
        try {
            return Optional.of((TableStatisticsData)this.objectMapper.readValue(resource, TableStatisticsData.class));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to parse stats from resource [%s]", resourcePath), e);
        }
    }

    private String tableStatisticsDataFilename(TpchTable<?> table, Optional<TpchColumn<?>> partitionColumn, Optional<String> partitionValue) {
        Optional<String> partitionDescription = this.getPartitionDescription(partitionColumn, partitionValue);
        return table.getTableName() + partitionDescription.map(value -> "." + value).orElse("");
    }

    private Optional<String> getPartitionDescription(Optional<TpchColumn<?>> partitionColumn, Optional<String> partitionValue) {
        Preconditions.checkArgument((partitionColumn.isPresent() == partitionValue.isPresent() ? 1 : 0) != 0);
        return Optionals.withBoth(partitionColumn, partitionValue, (column, value) -> column.getColumnName() + "." + value);
    }
}

