/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.tpch;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.tpch.ColumnNaming;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchPartitioningHandle;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.plugin.tpch.statistics.ColumnStatisticsData;
import io.prestosql.plugin.tpch.statistics.StatisticsEstimator;
import io.prestosql.plugin.tpch.statistics.TableStatisticsData;
import io.prestosql.plugin.tpch.statistics.TableStatisticsDataRepository;
import io.prestosql.plugin.tpch.util.PredicateUtils;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTablePartitioning;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SortOrder;
import io.prestosql.spi.connector.SortingProperty;
import io.prestosql.spi.connector.TableScanRedirectApplicationResult;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.statistics.ColumnStatistics;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.statistics.DoubleRange;
import io.prestosql.spi.statistics.Estimate;
import io.prestosql.spi.statistics.TableStatisticType;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.statistics.TableStatisticsMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.tpch.Distributions;
import io.prestosql.tpch.LineItemColumn;
import io.prestosql.tpch.OrderColumn;
import io.prestosql.tpch.PartColumn;
import io.prestosql.tpch.TpchColumn;
import io.prestosql.tpch.TpchColumnType;
import io.prestosql.tpch.TpchEntity;
import io.prestosql.tpch.TpchTable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TpchMetadata
implements ConnectorMetadata {
    public static final String TINY_SCHEMA_NAME = "tiny";
    public static final double TINY_SCALE_FACTOR = 0.01;
    public static final List<String> SCHEMA_NAMES = ImmutableList.of((Object)"tiny", (Object)"sf1", (Object)"sf100", (Object)"sf300", (Object)"sf1000", (Object)"sf3000", (Object)"sf10000", (Object)"sf30000", (Object)"sf100000");
    public static final String ROW_NUMBER_COLUMN_NAME = "row_number";
    private static final Set<Slice> ORDER_STATUS_VALUES = (Set)ImmutableSet.of((Object)"F", (Object)"O", (Object)"P").stream().map(Slices::utf8Slice).collect(ImmutableSet.toImmutableSet());
    private static final Set<NullableValue> ORDER_STATUS_NULLABLE_VALUES = ORDER_STATUS_VALUES.stream().map(value -> new NullableValue(TpchMetadata.getPrestoType(OrderColumn.ORDER_STATUS), value)).collect(Collectors.toSet());
    private static final Set<Slice> PART_TYPE_VALUES = (Set)Distributions.getDefaultDistributions().getPartTypes().getValues().stream().map(Slices::utf8Slice).collect(ImmutableSet.toImmutableSet());
    private static final Set<NullableValue> PART_TYPE_NULLABLE_VALUES = PART_TYPE_VALUES.stream().map(value -> new NullableValue(TpchMetadata.getPrestoType(PartColumn.TYPE), value)).collect(Collectors.toSet());
    private static final Set<Slice> PART_CONTAINER_VALUES = (Set)Distributions.getDefaultDistributions().getPartContainers().getValues().stream().map(Slices::utf8Slice).collect(ImmutableSet.toImmutableSet());
    private static final Set<NullableValue> PART_CONTAINER_NULLABLE_VALUES = PART_CONTAINER_VALUES.stream().map(value -> new NullableValue(TpchMetadata.getPrestoType(PartColumn.CONTAINER), value)).collect(Collectors.toSet());
    private final Set<String> tableNames;
    private final ColumnNaming columnNaming;
    private final StatisticsEstimator statisticsEstimator;
    private final boolean predicatePushdownEnabled;
    private final boolean partitioningEnabled;
    private final Optional<String> destinationCatalog;
    private final Optional<String> destinationSchema;

    public TpchMetadata() {
        this(ColumnNaming.SIMPLIFIED, true, true, Optional.empty(), Optional.empty());
    }

    public TpchMetadata(ColumnNaming columnNaming, boolean predicatePushdownEnabled, boolean partitioningEnabled, Optional<String> destinationCatalog, Optional<String> destinationSchema) {
        ImmutableSet.Builder tableNames = ImmutableSet.builder();
        for (TpchTable tpchTable : TpchTable.getTables()) {
            tableNames.add((Object)tpchTable.getTableName());
        }
        this.tableNames = tableNames.build();
        this.columnNaming = columnNaming;
        this.predicatePushdownEnabled = predicatePushdownEnabled;
        this.partitioningEnabled = partitioningEnabled;
        this.statisticsEstimator = TpchMetadata.createStatisticsEstimator();
        this.destinationCatalog = destinationCatalog;
        this.destinationSchema = destinationSchema;
    }

    private static StatisticsEstimator createStatisticsEstimator() {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
        TableStatisticsDataRepository tableStatisticsDataRepository = new TableStatisticsDataRepository(objectMapper);
        return new StatisticsEstimator(tableStatisticsDataRepository);
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        return TpchMetadata.schemaNameToScaleFactor(schemaName) > 0.0;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return SCHEMA_NAMES;
    }

    public TpchTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.tableNames.contains(tableName.getTableName())) {
            return null;
        }
        double scaleFactor = TpchMetadata.schemaNameToScaleFactor(tableName.getSchemaName());
        if (scaleFactor <= 0.0) {
            return null;
        }
        return new TpchTableHandle(tableName.getTableName(), scaleFactor);
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        return this.getTableHandle(session, tableName);
    }

    private Set<NullableValue> filterValues(Set<NullableValue> nullableValues, TpchColumn<?> column, Constraint constraint) {
        return nullableValues.stream().filter(PredicateUtils.convertToPredicate((TupleDomain<ColumnHandle>)constraint.getSummary(), this.toColumnHandle(column))).filter(value -> constraint.predicate().isEmpty() || ((Predicate)constraint.predicate().get()).test(ImmutableMap.of((Object)this.toColumnHandle(column), (Object)value))).collect(Collectors.toSet());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        TpchTable tpchTable = TpchTable.getTable((String)tpchTableHandle.getTableName());
        String schemaName = TpchMetadata.scaleFactorSchemaName(tpchTableHandle.getScaleFactor());
        return TpchMetadata.getTableMetadata(schemaName, tpchTable, this.columnNaming);
    }

    private static ConnectorTableMetadata getTableMetadata(String schemaName, TpchTable<?> tpchTable, ColumnNaming columnNaming) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (TpchColumn column : tpchTable.getColumns()) {
            columns.add((Object)ColumnMetadata.builder().setName(columnNaming.getName((TpchColumn<? extends TpchEntity>)column)).setType(TpchMetadata.getPrestoType(column)).setNullable(false).build());
        }
        columns.add((Object)ColumnMetadata.builder().setName(ROW_NUMBER_COLUMN_NAME).setType((Type)BigintType.BIGINT).setHidden(true).build());
        SchemaTableName tableName = new SchemaTableName(schemaName, tpchTable.getTableName());
        return new ConnectorTableMetadata(tableName, (List)columns.build());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getTableMetadata(session, tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TpchColumnHandle(columnMetadata.getName(), columnMetadata.getType()));
        }
        return builder.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (String schemaName : this.getSchemaNames(session, prefix.getSchema())) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                if (!prefix.getTable().map(tpchTable.getTableName()::equals).orElse(true).booleanValue()) continue;
                ConnectorTableMetadata tableMetadata = TpchMetadata.getTableMetadata(schemaName, tpchTable, this.columnNaming);
                tableColumns.put((Object)new SchemaTableName(schemaName, tpchTable.getTableName()), (Object)tableMetadata.getColumns());
            }
        }
        return tableColumns.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        String tableName = tpchTableHandle.getTableName();
        TpchTable tpchTable = TpchTable.getTable((String)tableName);
        Object columnValuesRestrictions = ImmutableMap.of();
        if (this.predicatePushdownEnabled) {
            columnValuesRestrictions = this.getColumnValuesRestrictions(tpchTable, constraint);
        }
        Optional<TableStatisticsData> optionalTableStatisticsData = this.statisticsEstimator.estimateStats((TpchTable<?>)tpchTable, (Map<TpchColumn<?>, List<Object>>)columnValuesRestrictions, tpchTableHandle.getScaleFactor());
        Map<String, ColumnHandle> columnHandles = this.getColumnHandles(session, tpchTableHandle);
        return optionalTableStatisticsData.map(tableStatisticsData -> this.toTableStatistics((TableStatisticsData)optionalTableStatisticsData.get(), tpchTableHandle, columnHandles)).orElse(TableStatistics.empty());
    }

    private Map<TpchColumn<?>, List<Object>> getColumnValuesRestrictions(TpchTable<?> tpchTable, Constraint constraint) {
        TupleDomain constraintSummary = constraint.getSummary();
        if (constraintSummary.isAll()) {
            return Collections.emptyMap();
        }
        if (constraintSummary.isNone()) {
            ImmutableSet columns = ImmutableSet.copyOf((Collection)tpchTable.getColumns());
            return Maps.asMap((Set)columns, key -> Collections.emptyList());
        }
        Map domains = (Map)constraintSummary.getDomains().get();
        Optional<Domain> orderStatusDomain = Optional.ofNullable((Domain)domains.get(this.toColumnHandle((TpchColumn<?>)OrderColumn.ORDER_STATUS)));
        Optional<Map> allowedColumnValues = orderStatusDomain.map(domain -> {
            List<Object> allowedValues = ORDER_STATUS_VALUES.stream().filter(arg_0 -> ((Domain)domain).includesNullableValue(arg_0)).collect(Collectors.toList());
            return this.avoidTrivialOrderStatusRestriction(allowedValues);
        });
        return allowedColumnValues.orElse(Collections.emptyMap());
    }

    private Map<TpchColumn<?>, List<Object>> avoidTrivialOrderStatusRestriction(List<Object> allowedValues) {
        if (allowedValues.containsAll(ORDER_STATUS_VALUES)) {
            return Collections.emptyMap();
        }
        return ImmutableMap.of((Object)OrderColumn.ORDER_STATUS, allowedValues);
    }

    private TableStatistics toTableStatistics(TableStatisticsData tableStatisticsData, TpchTableHandle tpchTableHandle, Map<String, ColumnHandle> columnHandles) {
        TableStatistics.Builder builder = TableStatistics.builder().setRowCount(Estimate.of((double)tableStatisticsData.getRowCount()));
        tableStatisticsData.getColumns().forEach((columnName, stats) -> {
            TpchColumnHandle columnHandle = (TpchColumnHandle)this.getColumnHandle(tpchTableHandle, columnHandles, (String)columnName);
            builder.setColumnStatistics((ColumnHandle)columnHandle, this.toColumnStatistics((ColumnStatisticsData)stats, columnHandle.getType()));
        });
        return builder.build();
    }

    private ColumnHandle getColumnHandle(TpchTableHandle tpchTableHandle, Map<String, ColumnHandle> columnHandles, String columnName) {
        TpchTable table = TpchTable.getTable((String)tpchTableHandle.getTableName());
        return columnHandles.get(this.columnNaming.getName((TpchColumn<? extends TpchEntity>)table.getColumn(columnName)));
    }

    private ColumnStatistics toColumnStatistics(ColumnStatisticsData stats, Type columnType) {
        return ColumnStatistics.builder().setNullsFraction(Estimate.zero()).setDistinctValuesCount(stats.getDistinctValuesCount().map(Estimate::of).orElse(Estimate.unknown())).setDataSize(stats.getDataSize().map(Estimate::of).orElse(Estimate.unknown())).setRange(TpchMetadata.toRange(stats.getMin(), stats.getMax(), columnType)).build();
    }

    private static Optional<DoubleRange> toRange(Optional<Object> min, Optional<Object> max, Type columnType) {
        if (columnType instanceof VarcharType) {
            return Optional.empty();
        }
        if (min.isEmpty() || max.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DoubleRange(TpchMetadata.toDouble(min.get(), columnType), TpchMetadata.toDouble(max.get(), columnType)));
    }

    private static double toDouble(Object value, Type columnType) {
        if (value instanceof String && columnType.equals(DateType.DATE)) {
            return LocalDate.parse((CharSequence)value).toEpochDay();
        }
        if (columnType.equals(BigintType.BIGINT) || columnType.equals(IntegerType.INTEGER) || columnType.equals(DateType.DATE)) {
            return ((Number)value).longValue();
        }
        if (columnType.equals(DoubleType.DOUBLE)) {
            return ((Number)value).doubleValue();
        }
        throw new IllegalArgumentException("unsupported column type " + columnType);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return new TableStatisticsMetadata((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)TableStatisticType.ROW_COUNT), (List)ImmutableList.of());
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Preconditions.checkArgument((boolean)(tableHandle instanceof TpchTableHandle));
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
    }

    @VisibleForTesting
    TpchColumnHandle toColumnHandle(TpchColumn<?> column) {
        return new TpchColumnHandle(this.columnNaming.getName(column), TpchMetadata.getPrestoType(column));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        String columnName = ((TpchColumnHandle)columnHandle).getColumnName();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Table '%s' does not have column '%s'", tableMetadata.getTable(), columnName));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> filterSchema) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String schemaName : this.getSchemaNames(session, filterSchema)) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                builder.add((Object)new SchemaTableName(schemaName, tpchTable.getTableName()));
            }
        }
        return builder.build();
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        ColumnHandle orderKeyColumn;
        TpchTableHandle tableHandle = (TpchTableHandle)table;
        Optional<Object> tablePartitioning = Optional.empty();
        Optional<Object> partitioningColumns = Optional.empty();
        ImmutableList localProperties = ImmutableList.of();
        Map<String, ColumnHandle> columns = this.getColumnHandles(session, tableHandle);
        if (this.partitioningEnabled && tableHandle.getTableName().equals(TpchTable.ORDERS.getTableName())) {
            orderKeyColumn = columns.get(this.columnNaming.getName((TpchColumn<? extends TpchEntity>)OrderColumn.ORDER_KEY));
            tablePartitioning = Optional.of(new ConnectorTablePartitioning((ConnectorPartitioningHandle)new TpchPartitioningHandle(TpchTable.ORDERS.getTableName(), this.calculateTotalRows(1500000, tableHandle.getScaleFactor())), (List)ImmutableList.of((Object)orderKeyColumn)));
            partitioningColumns = Optional.of(ImmutableSet.of((Object)orderKeyColumn));
            localProperties = ImmutableList.of((Object)new SortingProperty((Object)orderKeyColumn, SortOrder.ASC_NULLS_FIRST));
        } else if (this.partitioningEnabled && tableHandle.getTableName().equals(TpchTable.LINE_ITEM.getTableName())) {
            orderKeyColumn = columns.get(this.columnNaming.getName((TpchColumn<? extends TpchEntity>)LineItemColumn.ORDER_KEY));
            tablePartitioning = Optional.of(new ConnectorTablePartitioning((ConnectorPartitioningHandle)new TpchPartitioningHandle(TpchTable.ORDERS.getTableName(), this.calculateTotalRows(1500000, tableHandle.getScaleFactor())), (List)ImmutableList.of((Object)orderKeyColumn)));
            partitioningColumns = Optional.of(ImmutableSet.of((Object)orderKeyColumn));
            localProperties = ImmutableList.of((Object)new SortingProperty((Object)orderKeyColumn, SortOrder.ASC_NULLS_FIRST), (Object)new SortingProperty((Object)columns.get(this.columnNaming.getName((TpchColumn<? extends TpchEntity>)LineItemColumn.LINE_NUMBER)), SortOrder.ASC_NULLS_FIRST));
        }
        TupleDomain<ColumnHandle> constraint = tableHandle.getConstraint();
        if (this.predicatePushdownEnabled && constraint.isAll()) {
            if (tableHandle.getTableName().equals(TpchTable.ORDERS.getTableName())) {
                constraint = this.toTupleDomain((Map<TpchColumnHandle, Set<NullableValue>>)ImmutableMap.of((Object)this.toColumnHandle((TpchColumn<?>)OrderColumn.ORDER_STATUS), ORDER_STATUS_NULLABLE_VALUES));
            } else if (tableHandle.getTableName().equals(TpchTable.PART.getTableName())) {
                constraint = this.toTupleDomain((Map<TpchColumnHandle, Set<NullableValue>>)ImmutableMap.of((Object)this.toColumnHandle((TpchColumn<?>)PartColumn.CONTAINER), PART_CONTAINER_NULLABLE_VALUES, (Object)this.toColumnHandle((TpchColumn<?>)PartColumn.TYPE), PART_TYPE_NULLABLE_VALUES));
            }
        }
        return new ConnectorTableProperties(constraint, tablePartitioning, partitioningColumns, Optional.empty(), (List)localProperties);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TpchTableHandle handle = (TpchTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        TupleDomain<ColumnHandle> predicate = TupleDomain.all();
        TupleDomain<ColumnHandle> unenforcedConstraint = constraint.getSummary();
        if (this.predicatePushdownEnabled && handle.getTableName().equals(TpchTable.ORDERS.getTableName())) {
            predicate = this.toTupleDomain((Map<TpchColumnHandle, Set<NullableValue>>)ImmutableMap.of((Object)this.toColumnHandle((TpchColumn<?>)OrderColumn.ORDER_STATUS), this.filterValues(ORDER_STATUS_NULLABLE_VALUES, (TpchColumn<?>)OrderColumn.ORDER_STATUS, constraint)));
            unenforcedConstraint = PredicateUtils.filterOutColumnFromPredicate((TupleDomain<ColumnHandle>)constraint.getSummary(), this.toColumnHandle((TpchColumn<?>)OrderColumn.ORDER_STATUS));
        } else if (this.predicatePushdownEnabled && handle.getTableName().equals(TpchTable.PART.getTableName())) {
            predicate = this.toTupleDomain((Map<TpchColumnHandle, Set<NullableValue>>)ImmutableMap.of((Object)this.toColumnHandle((TpchColumn<?>)PartColumn.CONTAINER), this.filterValues(PART_CONTAINER_NULLABLE_VALUES, (TpchColumn<?>)PartColumn.CONTAINER, constraint), (Object)this.toColumnHandle((TpchColumn<?>)PartColumn.TYPE), this.filterValues(PART_TYPE_NULLABLE_VALUES, (TpchColumn<?>)PartColumn.TYPE, constraint)));
            unenforcedConstraint = PredicateUtils.filterOutColumnFromPredicate((TupleDomain<ColumnHandle>)constraint.getSummary(), this.toColumnHandle((TpchColumn<?>)PartColumn.CONTAINER));
            unenforcedConstraint = PredicateUtils.filterOutColumnFromPredicate(unenforcedConstraint, this.toColumnHandle((TpchColumn<?>)PartColumn.TYPE));
        }
        if (oldDomain.equals((Object)predicate)) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)new TpchTableHandle(handle.getTableName(), handle.getScaleFactor(), (TupleDomain<ColumnHandle>)oldDomain.intersect(predicate)), (TupleDomain)unenforcedConstraint));
    }

    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle table) {
        TpchTableHandle handle = (TpchTableHandle)table;
        if (this.destinationCatalog.isEmpty()) {
            return Optional.empty();
        }
        CatalogSchemaTableName destinationTable = new CatalogSchemaTableName(this.destinationCatalog.get(), this.destinationSchema.orElse(TpchMetadata.scaleFactorSchemaName(handle.getScaleFactor())), handle.getTableName());
        return Optional.of(new TableScanRedirectApplicationResult(destinationTable, (Map)ImmutableBiMap.copyOf(this.getColumnHandles(session, table)).inverse(), handle.getConstraint().transform(TpchColumnHandle.class::cast).transform(TpchColumnHandle::getColumnName)));
    }

    private TupleDomain<ColumnHandle> toTupleDomain(Map<TpchColumnHandle, Set<NullableValue>> predicate) {
        return TupleDomain.withColumnDomains(predicate.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Type type = ((TpchColumnHandle)entry.getKey()).getType();
            return ((Set)entry.getValue()).stream().map(nullableValue -> Domain.singleValue((Type)type, (Object)nullableValue.getValue())).reduce(Domain::union).orElse(Domain.none((Type)type));
        })));
    }

    private List<String> getSchemaNames(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isEmpty()) {
            return this.listSchemaNames(session);
        }
        if (TpchMetadata.schemaNameToScaleFactor(schemaName.get()) > 0.0) {
            return ImmutableList.of((Object)schemaName.get());
        }
        return ImmutableList.of();
    }

    private static String scaleFactorSchemaName(double scaleFactor) {
        return "sf" + scaleFactor;
    }

    public static double schemaNameToScaleFactor(String schemaName) {
        if (TINY_SCHEMA_NAME.equals(schemaName)) {
            return 0.01;
        }
        if (!schemaName.startsWith("sf")) {
            return -1.0;
        }
        try {
            return Double.parseDouble(schemaName.substring(2));
        }
        catch (Exception ignored) {
            return -1.0;
        }
    }

    public static Type getPrestoType(TpchColumn<?> column) {
        TpchColumnType tpchType = column.getType();
        switch (tpchType.getBase()) {
            case IDENTIFIER: {
                return BigintType.BIGINT;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case VARCHAR: {
                return VarcharType.createVarcharType((int)((int)((Long)tpchType.getPrecision().get()).longValue()));
            }
        }
        throw new IllegalArgumentException("Unsupported type " + tpchType);
    }

    private long calculateTotalRows(int scaleBase, double scaleFactor) {
        double totalRows = (double)scaleBase * scaleFactor;
        if (totalRows > 9.223372036854776E18) {
            throw new IllegalArgumentException("Total rows is larger than 2^64");
        }
        return (long)totalRows;
    }
}

