/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.tpch;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchRecordSet;
import io.prestosql.plugin.tpch.TpchSplit;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.tpch.TpchColumn;
import io.prestosql.tpch.TpchColumnType;
import io.prestosql.tpch.TpchColumnTypes;
import io.prestosql.tpch.TpchEntity;
import io.prestosql.tpch.TpchTable;
import java.util.List;

public class TpchRecordSetProvider
implements ConnectorRecordSetProvider {
    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        TpchSplit tpchSplit = (TpchSplit)split;
        TpchTableHandle tpchTable = (TpchTableHandle)table;
        return this.getRecordSet(TpchTable.getTable((String)tpchTable.getTableName()), columns, tpchTable.getScaleFactor(), tpchSplit.getPartNumber(), tpchSplit.getTotalParts(), tpchTable.getConstraint());
    }

    public <E extends TpchEntity> RecordSet getRecordSet(TpchTable<E> table, List<? extends ColumnHandle> columns, double scaleFactor, int partNumber, int totalParts, TupleDomain<ColumnHandle> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            String columnName = ((TpchColumnHandle)columnHandle).getColumnName();
            if (columnName.equalsIgnoreCase("row_number")) {
                builder.add(new RowNumberTpchColumn());
                continue;
            }
            builder.add((Object)table.getColumn(columnName));
        }
        return TpchRecordSet.createTpchRecordSet(table, builder.build(), scaleFactor, partNumber + 1, totalParts, predicate);
    }

    private static class RowNumberTpchColumn<E extends TpchEntity>
    implements TpchColumn<E> {
        private RowNumberTpchColumn() {
        }

        public String getColumnName() {
            return "row_number";
        }

        public TpchColumnType getType() {
            return TpchColumnTypes.IDENTIFIER;
        }

        public double getDouble(E entity) {
            throw new UnsupportedOperationException();
        }

        public long getIdentifier(E entity) {
            return entity.getRowNumber();
        }

        public int getInteger(E entity) {
            throw new UnsupportedOperationException();
        }

        public String getString(E entity) {
            throw new UnsupportedOperationException();
        }

        public int getDate(E entity) {
            throw new UnsupportedOperationException();
        }
    }
}

