/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.tpch;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.tpch.TpchMetadata;
import io.prestosql.plugin.tpch.TpchRecordSet;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.tpch.TpchTable;
import java.util.Iterator;
import java.util.List;

public final class TpchTables {
    private TpchTables() {
    }

    public static List<Type> getTableColumns(String tableName) {
        TpchTable table = TpchTable.getTable((String)tableName);
        return (List)table.getColumns().stream().map(TpchMetadata::getPrestoType).collect(ImmutableList.toImmutableList());
    }

    public static Iterator<Page> getTablePages(String tableName, double scaleFactor) {
        TpchTable table = TpchTable.getTable((String)tableName);
        RecordPageSource pageSource = new RecordPageSource(TpchRecordSet.createTpchRecordSet(table, table.getColumns(), scaleFactor, 1, 1, (TupleDomain<ColumnHandle>)TupleDomain.all()));
        return new AbstractIterator<Page>((ConnectorPageSource)pageSource){
            final /* synthetic */ ConnectorPageSource val$pageSource;
            {
                this.val$pageSource = connectorPageSource;
            }

            protected Page computeNext() {
                if (this.val$pageSource.isFinished()) {
                    return (Page)this.endOfData();
                }
                Page page = this.val$pageSource.getNextPage();
                if (page == null) {
                    return this.computeNext();
                }
                return page.getLoadedPage();
            }
        };
    }
}

