/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;

public interface Cache {
    public void set(String var1, Long var2, JsonNode var3);

    public JsonNode get(String var1);

    public JsonNode getOrSet(String var1, Long var2, Callback var3);

    public Boolean isExpired(String var1);

    public Boolean isPending(String var1);

    public static class BuiltInCache
    implements Cache {
        private final Map<String, Entry> cache;
        private final Map<String, State> states;

        public BuiltInCache(int maxDocuments) {
            this.cache = Collections.synchronizedMap(new LRUMap(maxDocuments));
            this.states = Collections.synchronizedMap(new HashMap());
        }

        public JsonNode get(String key) {
            Entry entry = this.cache.get(key);
            Boolean isExpired = this.isExpired(key);
            Boolean isPending = this.isPending(key);
            if (entry != null && (!isExpired.booleanValue() || isExpired.booleanValue() && isPending.booleanValue())) {
                return entry.value;
            }
            return null;
        }

        public void set(String key, Long ttl, JsonNode response) {
            Long expiration = ttl + System.currentTimeMillis();
            this.cache.put(key, new Entry(expiration, response));
        }

        public JsonNode getOrSet(String key, Long ttl, Callback f) {
            JsonNode found = this.get(key);
            if (found == null) {
                this.states.put(key, State.PENDING);
                JsonNode json = f.execute();
                this.set(key, ttl, json);
                this.states.remove(key);
                return json;
            }
            return found;
        }

        public Boolean isExpired(String key) {
            Entry entry = this.cache.get(key);
            if (entry != null) {
                return entry.expiration != 0L && entry.expiration < System.currentTimeMillis();
            }
            return false;
        }

        public Boolean isPending(String key) {
            return this.states.get(key) == State.PENDING;
        }

        static class Entry {
            public final Long expiration;
            public final JsonNode value;

            public Entry(Long expiration, JsonNode value) {
                this.expiration = expiration;
                this.value = value;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            PENDING;

        }
    }

    public static interface Callback {
        public JsonNode execute();
    }

    public static class DefaultCache {
        private static Cache defaultCache = new BuiltInCache(999);

        private DefaultCache() {
        }

        public static Cache getInstance() {
            return defaultCache;
        }
    }

    public static class NoCache
    implements Cache {
        public void set(String key, Long ttl, JsonNode response) {
        }

        public JsonNode get(String key) {
            return null;
        }

        public JsonNode getOrSet(String key, Long ttl, Callback f) {
            return f.execute();
        }

        public Boolean isExpired(String key) {
            return true;
        }

        public Boolean isPending(String key) {
            return false;
        }
    }
}

