/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.Variation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Experiment {
    private final String id;
    private final String googleId;
    private final String name;
    private final List<Variation> variations;
    @Deprecated
    public static String COOKIE_NAME = "io.prismic.experiment";

    public Experiment(String id, String googleId, String name, List<Variation> variations) {
        this.id = id;
        this.googleId = googleId;
        this.name = name;
        this.variations = Collections.unmodifiableList(variations);
    }

    public String getId() {
        return this.id;
    }

    public String getGoogleId() {
        return this.googleId;
    }

    public String getName() {
        return this.name;
    }

    public List<Variation> getVariations() {
        return this.variations;
    }

    static Experiment parse(JsonNode json) {
        String id = json.path("id").asText();
        String googleId = json.path("googleId").asText();
        String name = json.path("name").asText();
        ArrayList<Variation> variations = new ArrayList<Variation>();
        Iterator variationsJson = json.withArray("variations").elements();
        while (variationsJson.hasNext()) {
            variations.add(Variation.parse((JsonNode)variationsJson.next()));
        }
        return new Experiment(id, googleId, name, variations);
    }
}

