/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.Fragment;
import io.prismic.FragmentParser;
import io.prismic.LinkedDocument;
import io.prismic.WithFragments;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Document
extends WithFragments {
    private final String id;
    private final String href;
    private final Set<String> tags;
    private final List<String> slugs;
    private final String type;
    private final Map<String, Fragment> fragments;
    private final List<LinkedDocument> linkedDocuments;

    public Document(String id, String type, String href, Set<String> tags, List<String> slugs, List<LinkedDocument> linkedDocuments, Map<String, Fragment> fragments) {
        this.id = id;
        this.type = type;
        this.href = href;
        this.tags = Collections.unmodifiableSet(tags);
        this.slugs = Collections.unmodifiableList(slugs);
        this.fragments = Collections.unmodifiableMap(fragments);
        this.linkedDocuments = Collections.unmodifiableList(linkedDocuments);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getHref() {
        return this.href;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public List<String> getSlugs() {
        return this.slugs;
    }

    public String getSlug() {
        if (this.slugs.size() > 0) {
            return this.slugs.get(0);
        }
        return null;
    }

    public List<LinkedDocument> getLinkedDocuments() {
        return this.linkedDocuments;
    }

    @Override
    public Map<String, Fragment> getFragments() {
        return this.fragments;
    }

    public Fragment.Group getGroup(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Group) {
            return (Fragment.Group)fragment;
        }
        return null;
    }

    public String toString() {
        return "Document#" + this.id + " [" + this.type + "]";
    }

    static Document parse(JsonNode json, FragmentParser fragmentParser) {
        String id = json.path("id").asText();
        String href = json.path("href").asText();
        String type = json.path("type").asText();
        Iterator tagsJson = json.withArray("tags").elements();
        HashSet<String> tags = new HashSet<String>();
        while (tagsJson.hasNext()) {
            tags.add(((JsonNode)tagsJson.next()).asText());
        }
        Iterator slugsJson = json.withArray("slugs").elements();
        ArrayList<String> slugs = new ArrayList<String>();
        while (slugsJson.hasNext()) {
            try {
                slugs.add(URLDecoder.decode(((JsonNode)slugsJson.next()).asText(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<LinkedDocument> linkedDocuments = new ArrayList<LinkedDocument>();
        if (json.has("linked_documents")) {
            Iterator linkedDocumentsJson = json.withArray("linked_documents").elements();
            while (linkedDocumentsJson.hasNext()) {
                LinkedDocument linkedDocument = LinkedDocument.parse((JsonNode)linkedDocumentsJson.next());
                linkedDocuments.add(linkedDocument);
            }
        }
        Iterator dataJson = json.with("data").with(type).fieldNames();
        LinkedHashMap<String, Fragment> fragments = new LinkedHashMap<String, Fragment>();
        while (dataJson.hasNext()) {
            JsonNode fragmentValue;
            String field = (String)dataJson.next();
            JsonNode fieldJson = json.with("data").with(type).path(field);
            if (fieldJson.isArray()) {
                for (int i = 0; i < fieldJson.size(); ++i) {
                    JsonNode fragmentValue2;
                    String fragmentName = type + "." + field + "[" + i + "]";
                    String fragmentType = fieldJson.path(i).path("type").asText();
                    Fragment fragment = fragmentParser.parse(fragmentType, fragmentValue2 = fieldJson.path(i).path("value"));
                    if (fragment == null) continue;
                    fragments.put(fragmentName, fragment);
                }
                continue;
            }
            String fragmentName = type + "." + field;
            String fragmentType = fieldJson.path("type").asText();
            Fragment fragment = fragmentParser.parse(fragmentType, fragmentValue = fieldJson.path("value"));
            if (fragment == null) continue;
            fragments.put(fragmentName, fragment);
        }
        return new Document(id, type, href, tags, slugs, linkedDocuments, fragments);
    }
}

