/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.Api;
import io.prismic.Predicate;
import io.prismic.Ref;
import io.prismic.Response;
import io.prismic.Utils;
import io.prismic.core.HttpClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Form {
    private final String name;
    private final String method;
    private final String rel;
    private final String enctype;
    private final String action;
    private final Map<String, Field> fields;

    public Form(String name, String method, String rel, String enctype, String action, Map<String, Field> fields) {
        this.name = name;
        this.method = method.toUpperCase();
        this.rel = rel;
        this.enctype = enctype;
        this.action = action;
        this.fields = Collections.unmodifiableMap(fields);
    }

    public String getName() {
        return this.name;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRel() {
        return this.rel;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public String getAction() {
        return this.action;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.method + " " + this.action;
    }

    static Form parse(JsonNode json) {
        String name = json.path("name").asText();
        String method = json.path("method").asText();
        String rel = json.path("rel").asText();
        String enctype = json.path("enctype").asText();
        String action = json.path("action").asText();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Iterator fieldsJson = json.with("fields").fieldNames();
        while (fieldsJson.hasNext()) {
            String field = (String)fieldsJson.next();
            fields.put(field, Field.parse(json.with("fields").path(field)));
        }
        return new Form(name, method, rel, enctype, action, fields);
    }

    public static class SearchForm {
        private final Api api;
        private final Form form;
        private final Map<String, List<String>> data;

        public SearchForm(Api api, Form form) {
            this.api = api;
            this.form = form;
            this.data = new HashMap<String, List<String>>();
            for (Map.Entry<String, Field> field : form.getFields().entrySet()) {
                if (field.getValue().getDefaultValue() == null) continue;
                ArrayList<String> value = new ArrayList<String>(1);
                value.add(field.getValue().getDefaultValue());
                this.data.put(field.getKey(), value);
            }
        }

        public SearchForm set(String field, String value) {
            Field fieldDesc = this.form.getFields().get(field);
            if (fieldDesc == null) {
                throw new RuntimeException("Unknown field " + field);
            }
            if (value == null) {
                return this;
            }
            if (fieldDesc.isMultiple().booleanValue()) {
                List<String> existingValue = this.data.get(field);
                if (existingValue == null) {
                    existingValue = new ArrayList<String>();
                }
                existingValue.add(value);
                this.data.put(field, existingValue);
            } else {
                ArrayList<String> newValue = new ArrayList<String>();
                newValue.add(value);
                this.data.put(field, newValue);
            }
            return this;
        }

        public SearchForm set(String field, Integer value) {
            Field fieldDesc = this.form.getFields().get(field);
            if (fieldDesc == null) {
                throw new RuntimeException("Unknown field " + field);
            }
            if (!"Integer".equals(fieldDesc.getType())) {
                throw new RuntimeException("Cannot set an Integer value to field " + field + " of type " + fieldDesc.getType());
            }
            return this.set(field, value.toString());
        }

        public SearchForm ref(Ref ref) {
            return this.ref(ref.getRef());
        }

        public SearchForm ref(String ref) {
            return this.set("ref", ref);
        }

        public SearchForm pageSize(String pageSize) {
            return this.set("pageSize", pageSize);
        }

        public SearchForm pageSize(int pageSize) {
            return this.set("pageSize", pageSize);
        }

        public SearchForm page(String page) {
            return this.set("page", page);
        }

        public SearchForm fetch(String ... fields) {
            switch (fields.length) {
                case 0: {
                    return this;
                }
            }
            return this.set("fetch", Utils.mkString(fields, ","));
        }

        public SearchForm fetchLinks(String ... fields) {
            switch (fields.length) {
                case 0: {
                    return this;
                }
            }
            return this.set("fetchLinks", Utils.mkString(fields, ","));
        }

        public SearchForm page(int page) {
            return this.set("page", page);
        }

        public SearchForm orderings(String ... orderings) {
            switch (orderings.length) {
                case 0: {
                    return this;
                }
                case 1: {
                    return this.set("orderings", "[" + this.strip(orderings[0]) + "]");
                }
            }
            return this.set("orderings", "[" + Utils.mkString(orderings, ",") + "]");
        }

        private String strip(String q) {
            if (q == null) {
                return "";
            }
            String tq = q.trim();
            if (tq.indexOf("[") == 0 && tq.lastIndexOf("]") == tq.length() - 1) {
                return tq.substring(1, tq.length() - 1);
            }
            return tq;
        }

        public SearchForm query(String q) {
            Field fieldDesc = this.form.getFields().get("q");
            if (fieldDesc != null && fieldDesc.isMultiple().booleanValue()) {
                return this.set("q", q);
            }
            ArrayList<String> value = new ArrayList<String>();
            value.add("[ " + (this.form.getFields().containsKey("q") ? this.strip(this.form.getFields().get("q").getDefaultValue()) : "") + " " + this.strip(q) + " ]");
            this.data.put("q", value);
            return this;
        }

        public SearchForm query(Predicate ... predicates) {
            StringBuilder result = new StringBuilder();
            for (Predicate p : predicates) {
                result.append(p.q());
            }
            return this.query("[" + result.toString() + "]");
        }

        public Response submit() {
            if ("GET".equals(this.form.getMethod()) && "application/x-www-form-urlencoded".equals(this.form.getEnctype())) {
                StringBuilder url = new StringBuilder(this.form.getAction());
                String sep = this.form.getAction().contains("?") ? "&" : "?";
                for (Map.Entry<String, List<String>> d : this.data.entrySet()) {
                    for (String v : d.getValue()) {
                        url.append(sep).append(d.getKey()).append("=").append(HttpClient.encodeURIComponent(v));
                        sep = "&";
                    }
                }
                JsonNode json = HttpClient.fetch(url.toString(), this.api.getLogger(), this.api.getCache());
                return Response.parse(json);
            }
            throw new Api.Error(Api.Error.Code.UNEXPECTED, "Form type not supported");
        }

        public String toString() {
            StringBuilder dataStr = new StringBuilder();
            for (Map.Entry<String, List<String>> d : this.data.entrySet()) {
                for (String v : d.getValue()) {
                    dataStr.append(d.getKey()).append("=").append(v).append(" ");
                }
            }
            return this.form.toString() + " {" + dataStr.toString().trim() + "}";
        }
    }

    public static class Field {
        private final String type;
        private final Boolean multiple;
        private final String defaultValue;

        public Field(String type, Boolean multiple, String defaultValue) {
            this.type = type;
            this.multiple = multiple;
            this.defaultValue = defaultValue;
        }

        public String getType() {
            return this.type;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Boolean isMultiple() {
            return this.multiple;
        }

        static Field parse(JsonNode json) {
            String type = json.path("type").asText();
            String defaultValue = json.has("default") ? json.path("default").asText() : null;
            Boolean multiple = json.has("multiple") && json.path("multiple").asBoolean();
            return new Field(type, multiple, defaultValue);
        }
    }
}

