/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import io.prismic.Fragment;
import io.prismic.GroupDoc;
import io.prismic.HtmlSerializer;
import io.prismic.LinkResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class WithFragments {
    public abstract Map<String, Fragment> getFragments();

    public List<Fragment.DocumentLink> getLinkedDocuments() {
        ArrayList<Fragment.DocumentLink> result = new ArrayList<Fragment.DocumentLink>();
        for (Fragment fragment : this.getFragments().values()) {
            if (fragment instanceof Fragment.DocumentLink) {
                result.add((Fragment.DocumentLink)fragment);
            }
            if (fragment instanceof Fragment.Group) {
                for (GroupDoc doc : ((Fragment.Group)fragment).getDocs()) {
                    result.addAll(doc.getLinkedDocuments());
                }
            }
            if (!(fragment instanceof Fragment.StructuredText)) continue;
            Fragment.StructuredText text = (Fragment.StructuredText)fragment;
            for (Fragment.StructuredText.Block block : text.getBlocks()) {
                if (!(block instanceof Fragment.StructuredText.Block.Text)) continue;
                Fragment.StructuredText.Block.Text textBlock = (Fragment.StructuredText.Block.Text)block;
                for (Fragment.StructuredText.Span span : textBlock.getSpans()) {
                    Fragment.StructuredText.Span.Hyperlink hlink;
                    if (!(span instanceof Fragment.StructuredText.Span.Hyperlink) || !((hlink = (Fragment.StructuredText.Span.Hyperlink)span).getLink() instanceof Fragment.DocumentLink)) continue;
                    result.add((Fragment.DocumentLink)hlink.getLink());
                }
            }
        }
        return result;
    }

    public Fragment get(String field) {
        List<Fragment> multi;
        Fragment single = this.getFragments().get(field);
        if (single == null && (multi = this.getAll(field)).size() > 0) {
            single = multi.get(0);
        }
        return single;
    }

    public List<Fragment> getAll(String field) {
        ArrayList<Fragment> result = new ArrayList<Fragment>();
        for (Map.Entry<String, Fragment> entry : this.getFragments().entrySet()) {
            if (!entry.getKey().matches("\\Q" + field + "\\E\\[\\d+\\]")) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public Fragment.Image getImage(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Image) {
            return (Fragment.Image)fragment;
        }
        if (fragment != null && fragment instanceof Fragment.StructuredText) {
            for (Fragment.StructuredText.Block block : ((Fragment.StructuredText)fragment).getBlocks()) {
                if (!(block instanceof Fragment.StructuredText.Block.Image)) continue;
                return new Fragment.Image(((Fragment.StructuredText.Block.Image)block).getView());
            }
        }
        return null;
    }

    public List<Fragment.Image> getAllImages(String field) {
        List<Fragment> fragments = this.getAll(field);
        ArrayList<Fragment.Image> images = new ArrayList<Fragment.Image>();
        for (Fragment fragment : fragments) {
            if (fragment != null && fragment instanceof Fragment.Image) {
                images.add((Fragment.Image)fragment);
                continue;
            }
            if (fragment == null || !(fragment instanceof Fragment.StructuredText)) continue;
            for (Fragment.StructuredText.Block block : ((Fragment.StructuredText)fragment).getBlocks()) {
                if (!(block instanceof Fragment.StructuredText.Block.Image)) continue;
                images.add(new Fragment.Image(((Fragment.StructuredText.Block.Image)block).getView()));
            }
        }
        return images;
    }

    public Fragment.Image.View getImage(String field, String view) {
        Fragment.Image image = this.getImage(field);
        if (image != null) {
            return image.getView(view);
        }
        return null;
    }

    public List<Fragment.Image.View> getAllImages(String field, String view) {
        ArrayList<Fragment.Image.View> views = new ArrayList<Fragment.Image.View>();
        for (Fragment.Image image : this.getAllImages(field)) {
            Fragment.Image.View imageView = image.getView(view);
            if (imageView == null) continue;
            views.add(imageView);
        }
        return views;
    }

    public Fragment.StructuredText getStructuredText(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.StructuredText) {
            return (Fragment.StructuredText)fragment;
        }
        return null;
    }

    public Fragment.Link getLink(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Link) {
            return (Fragment.Link)fragment;
        }
        return null;
    }

    public Fragment.Embed getEmbed(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Embed) {
            return (Fragment.Embed)fragment;
        }
        return null;
    }

    public String getHtml(String field, LinkResolver linkResolver) {
        return this.getHtml(field, linkResolver, null);
    }

    public String getHtml(String field, LinkResolver linkResolver, HtmlSerializer htmlSerializer) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.StructuredText) {
            return ((Fragment.StructuredText)fragment).asHtml(linkResolver, htmlSerializer);
        }
        if (fragment != null && fragment instanceof Fragment.Number) {
            return ((Fragment.Number)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Color) {
            return ((Fragment.Color)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Text) {
            return ((Fragment.Text)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Date) {
            return ((Fragment.Date)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Embed) {
            return ((Fragment.Embed)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Image) {
            return ((Fragment.Image)fragment).asHtml(linkResolver);
        }
        if (fragment != null && fragment instanceof Fragment.WebLink) {
            return ((Fragment.WebLink)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.DocumentLink) {
            return ((Fragment.DocumentLink)fragment).asHtml(linkResolver);
        }
        if (fragment != null && fragment instanceof Fragment.Group) {
            return ((Fragment.Group)fragment).asHtml(linkResolver);
        }
        return "";
    }

    public String getText(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.StructuredText) {
            StringBuilder text = new StringBuilder();
            for (Fragment.StructuredText.Block block : ((Fragment.StructuredText)fragment).getBlocks()) {
                if (!(block instanceof Fragment.StructuredText.Block.Text)) continue;
                text.append(((Fragment.StructuredText.Block.Text)block).getText());
                text.append("\n");
            }
            return text.toString().trim();
        }
        if (fragment != null && fragment instanceof Fragment.Number) {
            return ((Fragment.Number)fragment).getValue().toString();
        }
        if (fragment != null && fragment instanceof Fragment.Color) {
            return ((Fragment.Color)fragment).getHexValue();
        }
        if (fragment != null && fragment instanceof Fragment.Text) {
            return ((Fragment.Text)fragment).getValue();
        }
        if (fragment != null && fragment instanceof Fragment.Date) {
            return ((Fragment.Date)fragment).getValue().toString();
        }
        return "";
    }

    public Fragment.Color getColor(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Color) {
            return (Fragment.Color)fragment;
        }
        return null;
    }

    public Fragment.Number getNumber(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Number) {
            return (Fragment.Number)fragment;
        }
        return null;
    }

    public Fragment.Date getDate(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Date) {
            return (Fragment.Date)fragment;
        }
        return null;
    }

    public Fragment.Timestamp getTimestamp(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Timestamp) {
            return (Fragment.Timestamp)fragment;
        }
        return null;
    }

    public Fragment.GeoPoint getGeoPoint(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.GeoPoint) {
            return (Fragment.GeoPoint)fragment;
        }
        return null;
    }

    public String getDate(String field, String pattern) {
        Fragment.Date date = this.getDate(field);
        if (date != null) {
            return date.asText(pattern);
        }
        return null;
    }

    public String getNumber(String field, String pattern) {
        Fragment.Number number = this.getNumber(field);
        if (number != null) {
            return number.asText(pattern);
        }
        return null;
    }

    public boolean getBoolean(String field) {
        String value;
        Fragment fragment = this.get(field);
        return fragment != null && fragment instanceof Fragment.Text && ("yes".equals(value = ((Fragment.Text)fragment).getValue().toLowerCase()) || "true".equals(value));
    }

    public String asHtml(LinkResolver linkResolver) {
        return this.asHtml(linkResolver, null);
    }

    public String asHtml(LinkResolver linkResolver, HtmlSerializer htmlSerializer) {
        StringBuilder html = new StringBuilder();
        for (Map.Entry<String, Fragment> fragment : this.getFragments().entrySet()) {
            html.append("<section data-field=\"" + fragment.getKey() + "\">");
            html.append(this.getHtml(fragment.getKey(), linkResolver, htmlSerializer));
            html.append("</section>\n");
        }
        return html.toString().trim();
    }
}

