/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.Fragment;
import io.prismic.WithFragments;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Document
extends WithFragments {
    private final String id;
    private final String uid;
    private final String href;
    private final Set<String> tags;
    private final List<String> slugs;
    private final String type;
    private final Map<String, Fragment> fragments;

    public Document(String id, String uid, String type, String href, Set<String> tags, List<String> slugs, Map<String, Fragment> fragments) {
        this.id = id;
        this.uid = uid;
        this.type = type;
        this.href = href;
        this.tags = Collections.unmodifiableSet(tags);
        this.slugs = Collections.unmodifiableList(slugs);
        this.fragments = Collections.unmodifiableMap(fragments);
    }

    public String getId() {
        return this.id;
    }

    public String getUid() {
        return this.uid;
    }

    public String getType() {
        return this.type;
    }

    public String getHref() {
        return this.href;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public List<String> getSlugs() {
        return this.slugs;
    }

    public String getSlug() {
        if (this.slugs.size() > 0) {
            return this.slugs.get(0);
        }
        return null;
    }

    @Override
    public Map<String, Fragment> getFragments() {
        return this.fragments;
    }

    public Fragment.Group getGroup(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Group) {
            return (Fragment.Group)fragment;
        }
        return null;
    }

    public String toString() {
        return "Document#" + this.id + " [" + this.type + "]";
    }

    public Fragment.DocumentLink asDocumentLink() {
        return new Fragment.DocumentLink(this.id, this.uid, this.type, this.tags, this.getSlug(), this.fragments, false);
    }

    static Fragment parseFragment(String type, JsonNode json) {
        if ("StructuredText".equals(type)) {
            return Fragment.StructuredText.parse(json);
        }
        if ("Image".equals(type)) {
            return Fragment.Image.parse(json);
        }
        if ("Link.web".equals(type)) {
            return Fragment.WebLink.parse(json);
        }
        if ("Link.document".equals(type)) {
            return Fragment.DocumentLink.parse(json);
        }
        if ("Link.file".equals(type)) {
            return Fragment.FileLink.parse(json);
        }
        if ("Link.image".equals(type)) {
            return Fragment.ImageLink.parse(json);
        }
        if ("Text".equals(type)) {
            return Fragment.Text.parse(json);
        }
        if ("Select".equals(type)) {
            return Fragment.Text.parse(json);
        }
        if ("Date".equals(type)) {
            return Fragment.Date.parse(json);
        }
        if ("Timestamp".equals(type)) {
            return Fragment.Timestamp.parse(json);
        }
        if ("Number".equals(type)) {
            return Fragment.Number.parse(json);
        }
        if ("Color".equals(type)) {
            return Fragment.Color.parse(json);
        }
        if ("Embed".equals(type)) {
            return Fragment.Embed.parse(json);
        }
        if ("GeoPoint".equals(type)) {
            return Fragment.GeoPoint.parse(json);
        }
        if ("Group".equals(type)) {
            return Fragment.Group.parse(json);
        }
        if ("SliceZone".equals(type)) {
            return Fragment.SliceZone.parse(json);
        }
        return null;
    }

    static Map<String, Fragment> parseFragments(JsonNode json, String type) {
        Iterator dataJson = json.fieldNames();
        LinkedHashMap<String, Fragment> fragments = new LinkedHashMap<String, Fragment>();
        while (dataJson.hasNext()) {
            JsonNode fragmentValue;
            String field = (String)dataJson.next();
            JsonNode fieldJson = json.path(field);
            if (fieldJson.isArray()) {
                for (int i = 0; i < fieldJson.size(); ++i) {
                    JsonNode fragmentValue2;
                    String fragmentName = type + "." + field + "[" + i + "]";
                    String fragmentType = fieldJson.path(i).path("type").asText();
                    Fragment fragment = Document.parseFragment(fragmentType, fragmentValue2 = fieldJson.path(i).path("value"));
                    if (fragment == null) continue;
                    fragments.put(fragmentName, fragment);
                }
                continue;
            }
            String fragmentName = type + "." + field;
            String fragmentType = fieldJson.path("type").asText();
            Fragment fragment = Document.parseFragment(fragmentType, fragmentValue = fieldJson.path("value"));
            if (fragment == null) continue;
            fragments.put(fragmentName, fragment);
        }
        return fragments;
    }

    public static Document parse(JsonNode json) {
        String id = json.path("id").asText();
        String uid = json.has("uid") ? json.path("uid").asText() : null;
        String href = json.path("href").asText();
        String type = json.path("type").asText();
        Iterator tagsJson = json.withArray("tags").elements();
        HashSet<String> tags = new HashSet<String>();
        while (tagsJson.hasNext()) {
            tags.add(((JsonNode)tagsJson.next()).asText());
        }
        Iterator slugsJson = json.withArray("slugs").elements();
        ArrayList<String> slugs = new ArrayList<String>();
        while (slugsJson.hasNext()) {
            try {
                slugs.add(URLDecoder.decode(((JsonNode)slugsJson.next()).asText(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        Map<String, Fragment> fragments = Document.parseFragments(json.with("data").with(type), type);
        return new Document(id, uid, type, href, tags, slugs, fragments);
    }
}

