/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.Cache;
import io.prismic.Document;
import io.prismic.Experiments;
import io.prismic.Form;
import io.prismic.LinkResolver;
import io.prismic.Logger;
import io.prismic.Predicate;
import io.prismic.Predicates;
import io.prismic.Ref;
import io.prismic.Response;
import io.prismic.core.HttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Api {
    private final ApiData apiData;
    private final String accessToken;
    private final Cache cache;
    private final Logger logger;

    public static String getVersion() {
        String path = "/version.properties";
        InputStream stream = Api.class.getResourceAsStream(path);
        if (stream == null) {
            return "UNKNOWN";
        }
        Properties props = new Properties();
        try {
            props.load(stream);
            stream.close();
            return (String)props.get("version");
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }

    public static Api get(String endpoint, String accessToken, Cache cache, final Logger logger) {
        final String url = accessToken == null ? endpoint : endpoint + "?access_token=" + HttpClient.encodeURIComponent(accessToken);
        JsonNode json = cache.getOrSet(url, 5000L, new Cache.Callback(){

            @Override
            public JsonNode execute() {
                return HttpClient.fetch(url, logger, null);
            }
        });
        ApiData apiData = ApiData.parse(json);
        return new Api(apiData, accessToken, cache, logger);
    }

    public static Api get(String url, Cache cache, Logger logger) {
        return Api.get(url, null, cache, logger);
    }

    public static Api get(String url, String accessToken) {
        return Api.get(url, accessToken, Cache.DefaultCache.getInstance(), new Logger.NoLogger());
    }

    public static Api get(String url) {
        return Api.get(url, null);
    }

    public Api(ApiData apiData, String accessToken, Cache cache, Logger logger) {
        this.apiData = apiData;
        this.accessToken = accessToken;
        this.cache = cache;
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Cache getCache() {
        return this.cache;
    }

    public List<Ref> getRefs() {
        return this.apiData.getRefs();
    }

    public Ref getRef(String label) {
        for (Ref ref : this.apiData.getRefs()) {
            if (!ref.getLabel().equals(label)) continue;
            return ref;
        }
        return null;
    }

    public Map<String, String> getBookmarks() {
        return this.apiData.getBookmarks();
    }

    public Map<String, String> getTypes() {
        return this.apiData.getTypes();
    }

    public List<String> getTags() {
        return this.apiData.getTags();
    }

    public Map<String, String> getFormNames() {
        HashMap<String, String> formNames = new HashMap<String, String>();
        if (this.apiData.getForms() != null) {
            for (Map.Entry<String, Form> formEntry : this.apiData.getForms().entrySet()) {
                formNames.put(formEntry.getKey(), formEntry.getValue().getName());
            }
        }
        return formNames;
    }

    public Form.SearchForm getForm(String form) {
        return new Form.SearchForm(this, this.apiData.getForms().get(form));
    }

    public Experiments getExperiments() {
        return this.apiData.getExperiments();
    }

    public Ref getMaster() {
        for (Ref ref : this.getRefs()) {
            if (!ref.isMasterRef()) continue;
            return ref;
        }
        throw new Error(Error.Code.UNEXPECTED, "No master?");
    }

    public Form.SearchForm query() {
        return this.getForm("everything").ref(this.getMaster());
    }

    public Form.SearchForm query(String q) {
        return this.getForm("everything").ref(this.getMaster()).query(q);
    }

    public Form.SearchForm query(Predicate ... predicates) {
        return this.getForm("everything").ref(this.getMaster()).query(predicates);
    }

    public Form.SearchForm getByIDs(Iterable<String> ids) {
        return this.query(Predicates.in("document.id", ids));
    }

    public Document queryFirst(Predicate p, String ref) {
        List<Document> results;
        if (ref == null) {
            ref = this.getMaster().getRef();
        }
        if ((results = this.query(p).ref(ref).submit().getResults()).size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public Document queryFirst(Predicate p) {
        return this.queryFirst(p, this.getMaster().getRef());
    }

    public Document getByID(String documentId, String ref) {
        return this.queryFirst(Predicates.at("document.id", documentId), ref);
    }

    public Document getByID(String documentId) {
        return this.getByID(documentId, null);
    }

    public Document getByUID(String documentType, String documentUid, String ref) {
        return this.queryFirst(Predicates.at("my." + documentType + ".uid", documentUid), ref);
    }

    public Document getByUID(String documentType, String documentUid) {
        return this.getByUID(documentType, documentUid, null);
    }

    public Document getBookmark(String bookmark, String ref) {
        return this.getByID((String)this.apiData.bookmarks.get(bookmark));
    }

    public Document getBookmark(String bookmark) {
        return this.getBookmark(bookmark, this.getMaster().getRef());
    }

    public String previewSession(String token, LinkResolver linkResolver, String defaultUrl) {
        JsonNode tokenJson = HttpClient.fetch(token, this.logger, this.cache);
        JsonNode mainDocumentId = tokenJson.path("mainDocument");
        if (!mainDocumentId.isTextual()) {
            return defaultUrl;
        }
        Response resp = this.query(Predicates.at("document.id", mainDocumentId.asText())).ref(token).submit();
        if (resp.getResults().size() == 0) {
            return defaultUrl;
        }
        return linkResolver.resolve(resp.getResults().get(0));
    }

    public String getOAuthInitiateEndpoint() {
        return this.apiData.getOAuthInitiateEndpoint();
    }

    public String getOAuthTokenEndpoint() {
        return this.apiData.getOAuthTokenEndpoint();
    }

    public static class ApiData {
        private final List<Ref> refs;
        private final Map<String, String> bookmarks;
        private final Map<String, String> types;
        private final List<String> tags;
        private final Map<String, Form> forms;
        private final String oauthInitiateEndpoint;
        private final String oauthTokenEndpoint;
        private final Experiments experiments;

        public ApiData(List<Ref> refs, Map<String, String> bookmarks, Map<String, String> types, List<String> tags, Map<String, Form> forms, Experiments experiments, String oauthInitiateEndpoint, String oauthTokenEndpoint) {
            this.refs = Collections.unmodifiableList(refs);
            this.bookmarks = Collections.unmodifiableMap(bookmarks);
            this.types = Collections.unmodifiableMap(types);
            this.tags = Collections.unmodifiableList(tags);
            this.forms = Collections.unmodifiableMap(forms);
            this.experiments = experiments;
            this.oauthInitiateEndpoint = oauthInitiateEndpoint;
            this.oauthTokenEndpoint = oauthTokenEndpoint;
        }

        public List<Ref> getRefs() {
            return this.refs;
        }

        public Map<String, String> getBookmarks() {
            return this.bookmarks;
        }

        public Map<String, String> getTypes() {
            return this.types;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public Map<String, Form> getForms() {
            return this.forms;
        }

        public String getOAuthInitiateEndpoint() {
            return this.oauthInitiateEndpoint;
        }

        public String getOAuthTokenEndpoint() {
            return this.oauthTokenEndpoint;
        }

        public Experiments getExperiments() {
            return this.experiments;
        }

        static ApiData parse(JsonNode json) {
            ArrayList<Ref> refs = new ArrayList<Ref>();
            Iterator refsJson = json.withArray("refs").elements();
            while (refsJson.hasNext()) {
                refs.add(Ref.parse((JsonNode)refsJson.next()));
            }
            HashMap<String, String> bookmarks = new HashMap<String, String>();
            Iterator bookmarksJson = json.with("bookmarks").fieldNames();
            while (bookmarksJson.hasNext()) {
                String bookmark = (String)bookmarksJson.next();
                bookmarks.put(bookmark, json.with("bookmarks").path(bookmark).asText());
            }
            HashMap<String, String> types = new HashMap<String, String>();
            Iterator typesJson = json.with("types").fieldNames();
            while (typesJson.hasNext()) {
                String type = (String)typesJson.next();
                types.put(type, json.with("types").path(type).asText());
            }
            ArrayList<String> tags = new ArrayList<String>();
            Iterator tagsJson = json.withArray("tags").elements();
            while (tagsJson.hasNext()) {
                tags.add(((JsonNode)tagsJson.next()).asText());
            }
            HashMap<String, Form> forms = new HashMap<String, Form>();
            Iterator formsJson = json.with("forms").fieldNames();
            while (formsJson.hasNext()) {
                String form = (String)formsJson.next();
                forms.put(form, Form.parse(json.with("forms").path(form)));
            }
            String oauthInitiateEndpoint = json.path("oauth_initiate").asText();
            String oauthTokenEndpoint = json.path("oauth_token").asText();
            Experiments experiments = Experiments.parse(json.path("experiments"));
            return new ApiData(refs, bookmarks, types, tags, forms, experiments, oauthInitiateEndpoint, oauthTokenEndpoint);
        }
    }

    public static class Error
    extends RuntimeException {
        private final Code code;

        public Error(Code code, String message) {
            super(message);
            this.code = code;
        }

        public Code getCode() {
            return this.code;
        }

        @Override
        public String toString() {
            return "[" + (Object)((Object)this.code) + "] " + this.getMessage();
        }

        public static enum Code {
            MALFORMED_URL,
            AUTHORIZATION_NEEDED,
            INVALID_TOKEN,
            TOO_MANY_REQUESTS,
            UNEXPECTED;

        }
    }
}

