/*
 * Decompiled with CFR 0.152.
 */
package io.prismic.servlet;

import io.prismic.Api;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

@WebFilter(filterName="Prismic")
public class PrismicFilter
implements Filter {
    private String endpoint;
    private String accessToken;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.endpoint = filterConfig.getInitParameter("endpoint");
        this.accessToken = filterConfig.getInitParameter("accessToken");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.endpoint == null) {
            throw new ServletException("Missing parameter in PrismicFilter: endpoint");
        }
        String referenceFromCookies = this.getRefFromCookies(req.getCookies());
        Api api = Api.get(this.endpoint, this.accessToken, referenceFromCookies);
        request.setAttribute("prismicapi", (Object)api);
        chain.doFilter(request, response);
    }

    private String getRefFromCookies(Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        String experimentCookie = null;
        String previewCookie = null;
        for (Cookie cookie : cookies) {
            if ("io.prismic.experiment".equals(cookie.getName())) {
                experimentCookie = cookie.getValue();
            }
            if (!"io.prismic.preview".equals(cookie.getName())) continue;
            previewCookie = cookie.getValue();
        }
        if (previewCookie != null) {
            return previewCookie;
        }
        if (experimentCookie != null) {
            return experimentCookie;
        }
        return null;
    }
}

