/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import io.prismic.Predicate;
import io.prismic.Predicates;
import java.time.ZonedDateTime;

class SimplePredicate
implements Predicate {
    private final String name;
    private final String fragment;
    private final Object value1;
    private final Object value2;
    private final Object value3;

    SimplePredicate(String name, String fragment, Object value1) {
        this(name, fragment, value1, null, null);
    }

    SimplePredicate(String name, String fragment, Object value1, Object value2) {
        this(name, fragment, value1, value2, null);
    }

    SimplePredicate(String name, String fragment, Object value1, Object value2, Object value3) {
        this.name = name;
        this.fragment = fragment;
        this.value1 = value1;
        this.value2 = value2;
        this.value3 = value3;
    }

    @Override
    public String q() {
        String result = "[:d = " + this.name + "(";
        result = "similar".equals(this.name) ? result + "\"" + this.fragment + "\"" : result + this.fragment;
        result = result + ", " + SimplePredicate.serializeField(this.value1);
        if (this.value2 != null) {
            result = result + ", " + SimplePredicate.serializeField(this.value2);
        }
        if (this.value3 != null) {
            result = result + ", " + SimplePredicate.serializeField(this.value3);
        }
        result = result + ")]";
        return result;
    }

    private static String serializeField(Object value) {
        if (value instanceof Iterable) {
            return "[" + SimplePredicate.join((Iterable)value) + "]";
        }
        if (value instanceof Predicates.Month) {
            return "\"" + SimplePredicate.capitalize(((Predicates.Month)((Object)value)).name()) + "\"";
        }
        if (value instanceof Predicates.DayOfWeek) {
            return "\"" + SimplePredicate.capitalize(((Predicates.DayOfWeek)((Object)value)).name()) + "\"";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof ZonedDateTime) {
            return Long.toString(((ZonedDateTime)value).toInstant().toEpochMilli());
        }
        return value.toString();
    }

    private static <T> String join(Iterable<T> elements) {
        if (!elements.iterator().hasNext()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (T elt : elements) {
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append("\"").append(elt).append("\"");
        }
        return result.toString();
    }

    private static String capitalize(String line) {
        if (line == null || "".equals(line)) {
            return "";
        }
        return Character.toUpperCase(line.charAt(0)) + line.substring(1).toLowerCase();
    }
}

