/*
 * Decompiled with CFR 0.152.
 */
package io.privy.auth.jwt;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J?\u0010\u0014\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lio/privy/auth/jwt/Jwt;", "", "header", "", "", "Lkotlinx/serialization/json/JsonPrimitive;", "claims", "signature", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/lang/String;)V", "getHeader", "()Ljava/util/Map;", "getClaims", "getSignature", "()Ljava/lang/String;", "isExpired", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "impl_release"})
public final class Jwt {
    @NotNull
    private final Map<String, JsonPrimitive> header;
    @NotNull
    private final Map<String, JsonPrimitive> claims;
    @NotNull
    private final String signature;

    public Jwt(@NotNull Map<String, ? extends JsonPrimitive> header, @NotNull Map<String, ? extends JsonPrimitive> claims, @NotNull String signature) {
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.header = header;
        this.claims = claims;
        this.signature = signature;
    }

    @NotNull
    public final Map<String, JsonPrimitive> getHeader() {
        return this.header;
    }

    @NotNull
    public final Map<String, JsonPrimitive> getClaims() {
        return this.claims;
    }

    @NotNull
    public final String getSignature() {
        return this.signature;
    }

    public final boolean isExpired() {
        Long l;
        JsonPrimitive jsonPrimitive = this.claims.get("exp");
        if (jsonPrimitive != null && (l = JsonElementKt.getLongOrNull((JsonPrimitive)jsonPrimitive)) != null) {
            long currentTimeMilliseconds;
            long expirationInSeconds = DurationKt.toDuration((long)l, (DurationUnit)DurationUnit.SECONDS);
            boolean bl = false;
            long expirationInMilliseconds = Duration.getInWholeMilliseconds-impl((long)expirationInSeconds);
            return expirationInMilliseconds < (currentTimeMilliseconds = Clock.System.INSTANCE.now().toEpochMilliseconds());
        }
        boolean bl = false;
        return true;
    }

    @NotNull
    public final Map<String, JsonPrimitive> component1() {
        return this.header;
    }

    @NotNull
    public final Map<String, JsonPrimitive> component2() {
        return this.claims;
    }

    @NotNull
    public final String component3() {
        return this.signature;
    }

    @NotNull
    public final Jwt copy(@NotNull Map<String, ? extends JsonPrimitive> header, @NotNull Map<String, ? extends JsonPrimitive> claims, @NotNull String signature) {
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        return new Jwt(header, claims, signature);
    }

    public static /* synthetic */ Jwt copy$default(Jwt jwt, Map map2, Map map3, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = jwt.header;
        }
        if ((n & 2) != 0) {
            map3 = jwt.claims;
        }
        if ((n & 4) != 0) {
            string = jwt.signature;
        }
        return jwt.copy(map2, map3, string);
    }

    @NotNull
    public String toString() {
        return "Jwt(header=" + this.header + ", claims=" + this.claims + ", signature=" + this.signature + ")";
    }

    public int hashCode() {
        int result = ((Object)this.header).hashCode();
        result = result * 31 + ((Object)this.claims).hashCode();
        result = result * 31 + this.signature.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Jwt)) {
            return false;
        }
        Jwt jwt = (Jwt)other;
        if (!Intrinsics.areEqual(this.header, jwt.header)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.claims, jwt.claims)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signature, (Object)jwt.signature);
    }
}

