package io.privy.auth

import io.privy.auth.customAuth.LoginWithCustomAuth
import io.privy.auth.customAuth.RealLoginWithCustomAuth
import io.privy.auth.email.LoginWithEmail
import io.privy.auth.email.RealLoginWithEmail
import io.privy.auth.jwt.DecodeJwt
import io.privy.auth.jwt.RealDecodeJwt
import io.privy.auth.persistence.AuthSessionDataStore
import io.privy.auth.persistence.DataStoreBindings
import io.privy.auth.persistence.RealAuthSessionDataStore
import io.privy.auth.session.AuthSessionResponseDeserializer
import io.privy.auth.session.RealAuthSessionResponseDeserializer
import io.privy.auth.session.internal.InternalAuthSessionSerializer
import io.privy.auth.session.internal.MapAuthSessionResponseToInternalAuthSession
import io.privy.auth.session.internal.RealInternalAuthSessionSerializer
import io.privy.auth.session.internal.RealMapAuthSessionResponseToInternalAuthSession
import io.privy.auth.sms.LoginWithSms
import io.privy.auth.sms.RealLoginWithSms
import io.privy.di.KmpAppScope
import me.tatarka.inject.annotations.Provides

public interface AuthBindings : DataStoreBindings {
  public val loginWithSms: LoginWithSms

  public val loginWithEmail: LoginWithEmail

  public val loginWithCustomAuth: LoginWithCustomAuth

  public val authRepository: AuthRepository

  public val authManager: AuthManager

  public val authStateRepository: AuthStateRepository

  @Provides public fun RealAuthRepository.bind(): AuthRepository = this

  @Provides public fun RealLoginWithSms.bind(): LoginWithSms = this

  @Provides public fun RealLoginWithEmail.bind(): LoginWithEmail = this

  @Provides public fun RealLoginWithCustomAuth.bind(): LoginWithCustomAuth = this

  @Provides
  public fun internalAuthStateRepository(
      real: RealAuthStateRepository
  ): InternalAuthStateRepository = real

  @Provides
  public fun authStateRepository(real: RealAuthStateRepository): AuthStateRepository = real

  @Provides public fun authRefreshService(real: RealAuthRefreshService): AuthRefreshService = real

  @KmpAppScope @Provides public fun RealAuthManager.bind(): AuthManager = this

  @Provides
  public fun RealAuthSessionResponseDeserializer.bind(): AuthSessionResponseDeserializer = this

  @Provides
  public fun RealInternalAuthSessionSerializer.bind(): InternalAuthSessionSerializer = this

  @Provides
  public fun RealMapAuthSessionResponseToInternalAuthSession.bind():
      MapAuthSessionResponseToInternalAuthSession = this

  @Provides public fun RealDecodeJwt.bind(): DecodeJwt = this

  @Provides public fun RealPrivyUser.bind(): PrivyUser = this

  @KmpAppScope @Provides public fun RealAuthSessionDataStore.bind(): AuthSessionDataStore = this
}
