package io.privy.auth.session

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
public data class AuthSessionResponse(
    val user: PrivyUserResponse,
    val token: String,
    @SerialName("refresh_token") val refreshToken: String,
    @SerialName("session_update_action") val sessionUpdateAction: String
)

@Serializable
public data class RefreshUserResponse(
    val user: PrivyUserResponse,
)

@Serializable
public data class PrivyUserResponse(
    val id: String,
    @SerialName("linked_accounts") val linkedAccounts: List<LinkedAccountResponse>,
)

@Serializable
public sealed interface LinkedAccountResponse {
  @Serializable
  @SerialName("custom_auth")
  public data class CustomAuth(
      @SerialName("custom_user_id") val customUserId: String,
      @SerialName("first_verified_at") val firstVerifiedAt: Int?,
      @SerialName("latest_verified_at") val latestVerifiedAt: Int?
  ) : LinkedAccountResponse

  @Serializable
  @SerialName("wallet")
  public data class WalletAccount(
      val address: String,
      @SerialName("chain_id") val chainId: String?,
      @SerialName("chain_type") val chainType: String?,
      @SerialName("wallet_client_type") val walletClientType: String,
      @SerialName("connector_type") val connectorType: String?,
      @SerialName("recovery_method") val recoveryMethod: String?,
      @SerialName("wallet_index") val hdWalletIndex: Int?,
      @SerialName("first_verified_at") val firstVerifiedAt: Int?,
      @SerialName("latest_verified_at") val latestVerifiedAt: Int?,
  ) : LinkedAccountResponse {
    public fun isPrivyWallet(): Boolean {
      return walletClientType == "privy" && connectorType == "embedded"
    }
  }

  @Serializable
  @SerialName("phone")
  public data class PhoneNumberAccount(@SerialName("phoneNumber") val phoneNumber: String) :
      LinkedAccountResponse

  @Serializable
  @SerialName("email")
  public data class EmailAddressAccount(@SerialName("address") val emailAddress: String) :
      LinkedAccountResponse

  @Serializable
  @SerialName("unknown")
  public data class UnknownAccount(val type: String) : LinkedAccountResponse
}
