/*
 * Decompiled with CFR 0.152.
 */
package io.privy.auth;

import io.privy.auth.LoginType;
import io.privy.auth.internal.LoginMethod;
import io.privy.auth.otp.OtpRequestType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\u0018\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\u0018\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006*\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"toLoginMethod", "Lio/privy/auth/internal/LoginMethod;", "Lio/privy/auth/LoginType;", "apiPath", "", "requestBody", "", "Lio/privy/auth/otp/OtpRequestType;", "impl_release"})
public final class RealAuthRepositoryKt {
    private static final LoginMethod toLoginMethod(LoginType $this$toLoginMethod) {
        LoginMethod loginMethod;
        LoginType loginType = $this$toLoginMethod;
        if (loginType instanceof LoginType.CustomAccessToken) {
            loginMethod = LoginMethod.CustomAccessToken;
        } else if (loginType instanceof LoginType.Sms) {
            loginMethod = LoginMethod.Sms;
        } else if (loginType instanceof LoginType.Email) {
            loginMethod = LoginMethod.Email;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return loginMethod;
    }

    private static final String apiPath(LoginType $this$apiPath) {
        String string;
        LoginType loginType = $this$apiPath;
        if (loginType instanceof LoginType.CustomAccessToken) {
            string = "custom_jwt_account";
        } else if (loginType instanceof LoginType.Sms) {
            string = "passwordless_sms";
        } else if (loginType instanceof LoginType.Email) {
            string = "passwordless";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final Map<String, String> requestBody(LoginType $this$requestBody) {
        Map map2;
        LoginType loginType = $this$requestBody;
        if (loginType instanceof LoginType.CustomAccessToken) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"token", (Object)((LoginType.CustomAccessToken)$this$requestBody).getToken()));
        } else if (loginType instanceof LoginType.Sms) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"phoneNumber", (Object)((LoginType.Sms)$this$requestBody).getPhoneNumber()), TuplesKt.to((Object)"code", (Object)((LoginType.Sms)$this$requestBody).getCode())};
            map2 = MapsKt.mapOf((Pair[])pairArray);
        } else if (loginType instanceof LoginType.Email) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"email", (Object)((LoginType.Email)$this$requestBody).getEmailAddress()), TuplesKt.to((Object)"code", (Object)((LoginType.Email)$this$requestBody).getCode())};
            map2 = MapsKt.mapOf((Pair[])pairArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map2;
    }

    private static final String apiPath(OtpRequestType $this$apiPath) {
        String string;
        OtpRequestType otpRequestType = $this$apiPath;
        if (otpRequestType instanceof OtpRequestType.Email) {
            string = "passwordless";
        } else if (otpRequestType instanceof OtpRequestType.Phone) {
            string = "passwordless_sms";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final Map<String, String> requestBody(OtpRequestType $this$requestBody) {
        Map map2;
        OtpRequestType otpRequestType = $this$requestBody;
        if (otpRequestType instanceof OtpRequestType.Email) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"email", (Object)((OtpRequestType.Email)$this$requestBody).unbox-impl()));
        } else if (otpRequestType instanceof OtpRequestType.Phone) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"phoneNumber", (Object)((OtpRequestType.Phone)$this$requestBody).unbox-impl()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map2;
    }

    public static final /* synthetic */ String access$apiPath(LoginType $receiver) {
        return RealAuthRepositoryKt.apiPath($receiver);
    }

    public static final /* synthetic */ Map access$requestBody(LoginType $receiver) {
        return RealAuthRepositoryKt.requestBody($receiver);
    }

    public static final /* synthetic */ LoginMethod access$toLoginMethod(LoginType $receiver) {
        return RealAuthRepositoryKt.toLoginMethod($receiver);
    }

    public static final /* synthetic */ String access$apiPath(OtpRequestType $receiver) {
        return RealAuthRepositoryKt.apiPath($receiver);
    }

    public static final /* synthetic */ Map access$requestBody(OtpRequestType $receiver) {
        return RealAuthRepositoryKt.requestBody($receiver);
    }
}

