package io.privy.auth.siwe

import io.privy.auth.internal.InternalSiweMessage
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable


@Serializable
public data class GenerateSiweMessageResponse(
    val nonce: String,
    val address: String,
    @SerialName("expires_at") val expiresAt: String
)

internal fun GenerateSiweMessageResponse.toInternalSiweMessage(): InternalSiweMessage {
    return with(this) { InternalSiweMessage(nonce = nonce, address = address, expiresAt = expiresAt) }
}
