package io.privy.auth.persistence

import android.content.Context
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler
import androidx.datastore.preferences.core.emptyPreferences
import io.privy.di.KmpAppScope
import me.tatarka.inject.annotations.Provides

@Suppress("EXPECT_ACTUAL_CLASSIFIERS_ARE_IN_BETA_WARNING")
public actual interface DataStoreBindings {
  @Provides
  @KmpAppScope
  public fun providePreferencesDataStore(context: Context): AuthSessionDataStoreHolder {
    return AuthSessionDataStoreHolder(
        createDataStoreWithPath(
            corruptionHandler =
                ReplaceFileCorruptionHandler {
                  // if file is corrupted, empty it out
                  emptyPreferences()
                },
            producePath = { context.filesDir.resolve(dataStoreFileName).absolutePath }))
  }
}
