package io.privy.auth.otp

import kotlin.jvm.JvmInline

public sealed interface OtpRequestType {
  /**
   * Represents a request to send an OTP to an email address.
   *
   * @property email The email address to send the OTP to.
   */
  @JvmInline public value class Email(public val email: String) : OtpRequestType

  /**
   * Represents a request to send an OTP to a phone number.
   *
   * @property phone The phone number to send the OTP to.
   */
  @JvmInline public value class Phone(public val phone: String) : OtpRequestType
}
