package io.privy.auth.jwt

import kotlinx.datetime.Clock
import kotlinx.serialization.json.JsonPrimitive
import kotlinx.serialization.json.longOrNull
import kotlin.time.Duration.Companion.seconds

public data class Jwt(
  val header:  Map<String, JsonPrimitive>,
  val claims:  Map<String, JsonPrimitive>,
  val signature: String,
) {
  public fun isExpired(): Boolean {
    return claims["exp"]?.longOrNull?.seconds?.let { expirationInSeconds ->
      val expirationInMilliseconds = expirationInSeconds.inWholeMilliseconds
      val currentTimeMilliseconds = Clock.System.now().toEpochMilliseconds()
      return expirationInMilliseconds < currentTimeMilliseconds
    } ?: kotlin.run {
      // If expiration couldn't be parsed from JWT, consider it invalid and expired
      true
    }
  }
}

