package io.privy.auth.session.internal

import io.privy.auth.internal.InternalAuthSession
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import me.tatarka.inject.annotations.Inject

public interface InternalAuthSessionSerializer {
  public fun serialize(internalAuthSession: InternalAuthSession): String

  public fun deserializeOrNull(json: String): InternalAuthSession?
}

@Inject
public class RealInternalAuthSessionSerializer: InternalAuthSessionSerializer {
  @OptIn(ExperimentalSerializationApi::class)
  private val internalAuthSessionSerializer = Json {
    prettyPrint = true
    isLenient = true
    ignoreUnknownKeys = true
    explicitNulls = false
  }

  override fun serialize(internalAuthSession: InternalAuthSession): String {
    return internalAuthSessionSerializer.encodeToString(internalAuthSession)
  }

  override fun deserializeOrNull(json: String): InternalAuthSession? {
    return try {
      internalAuthSessionSerializer.decodeFromString<InternalAuthSession>(json)
    } catch (e: Exception) {
      null
    }
  }
}