package io.privy.auth.session.internal

import io.privy.auth.LoginType
import io.privy.auth.internal.InternalAuthSession
import io.privy.auth.internal.InternalLinkedAccount
import io.privy.auth.internal.InternalPrivyUser
import io.privy.auth.internal.LoginMethod
import io.privy.auth.internal.SessionUpdateAction
import io.privy.auth.session.AuthSessionResponse
import io.privy.auth.session.LinkedAccountResponse
import io.privy.auth.session.PrivyUserResponse
import me.tatarka.inject.annotations.Inject

public interface MapAuthSessionResponseToInternalAuthSession {
  public fun map(
    authSessionResponse: AuthSessionResponse,
    loginMethod: LoginMethod,
    ): InternalAuthSession
}

@Inject
public class RealMapAuthSessionResponseToInternalAuthSession: MapAuthSessionResponseToInternalAuthSession {
  override fun map(authSessionResponse: AuthSessionResponse, loginMethod: LoginMethod): InternalAuthSession {
    return with(authSessionResponse) {
      InternalAuthSession(
        user = user.toInternalPrivyUser(),
        accessToken = token,
        refreshToken = refreshToken,
        loginMethod = loginMethod,
        sessionUpdateAction = SessionUpdateAction.fromString(sessionUpdateAction)
      )
    }
  }
}