package io.privy.auth.persistence

import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler
import androidx.datastore.preferences.core.emptyPreferences
// import io.privy.di.KmpAppScope
import kotlinx.cinterop.ExperimentalForeignApi
import me.tatarka.inject.annotations.Provides
import platform.Foundation.NSDocumentDirectory
import platform.Foundation.NSFileManager
import platform.Foundation.NSURL
import platform.Foundation.NSUserDomainMask

@Suppress("EXPECT_ACTUAL_CLASSIFIERS_ARE_IN_BETA_WARNING")
public actual interface DataStoreBindings {
  @Provides

  // FOR SOME REASON, ./gradlew compileIosMainKotlinMetadata doesn't like @KmpAppScope
  // Commenting out for now, but will have to figure out when we use KMP
  // Find other instances of this in `iosMain` when resolved
  // @KmpAppScope
  public fun providePreferencesDataStore(): AuthSessionDataStoreHolder {
    return AuthSessionDataStoreHolder(
      createDataStoreWithPath(
        corruptionHandler = ReplaceFileCorruptionHandler {
          // if file is corrupted, empty it out
          emptyPreferences()
        },
        producePath = { iosFilePath() }
      )
    )
  }

  @OptIn(ExperimentalForeignApi::class)
  private fun iosFilePath(): String {
    val documentDirectory: NSURL? = NSFileManager.defaultManager.URLForDirectory(
      directory = NSDocumentDirectory,
      inDomain = NSUserDomainMask,
      appropriateForURL = null,
      create = false,
      error = null,
    )

    return "${requireNotNull(documentDirectory).path}/$dataStoreFileName"
  }
}