package io.privy.auth

import io.privy.auth.internal.InternalAuthSession
import io.privy.auth.internal.InternalPrivyUser
import io.privy.auth.internal.InternalSiweMessage
import io.privy.auth.internal.LoginMethod
import io.privy.auth.otp.OtpRequestType
import io.privy.network.ApiResult

public interface AuthRepository {
  public suspend fun authenticate(loginType: LoginType): ApiResult<InternalAuthSession>

  public suspend fun refreshSession(
      authToken: String,
      refreshToken: String,
      currentLoginMethod: LoginMethod,
  ): ApiResult<InternalAuthSession>

  public suspend fun refreshUser(authToken: String): ApiResult<InternalPrivyUser>

  public suspend fun sendOtp(otpRequestType: OtpRequestType): ApiResult<Boolean>

  public suspend fun link(loginType: LoginType, authToken: String): ApiResult<InternalPrivyUser>

  public suspend fun generateSiweMessage(walletAddress: String): ApiResult<InternalSiweMessage>
}
