package io.privy.auth.sms

import io.privy.auth.AuthManager
import io.privy.auth.AuthenticationException
import io.privy.auth.LoginType
import io.privy.auth.PrivyUser
import io.privy.auth.otp.OtpRequestType
import me.tatarka.inject.annotations.Inject

@Inject
public class RealLoginWithSms(private val authManager: AuthManager) : LoginWithSms {
  // cache phone number otp was sent to
  private var phoneNumberOtpSentTo: String? = null

  override suspend fun sendCode(phoneNumber: String): Result<Unit> {
    return authManager.sendOtp(otpRequestType = OtpRequestType.Phone(phoneNumber)).onSuccess {
      // Cache phone number OTP was sent to
      this.phoneNumberOtpSentTo = phoneNumber
    }
  }

  override suspend fun loginWithCode(code: String, phoneNumber: String?): Result<PrivyUser> {
    // if phone number specified in method parameters, use it, else fall back to cached
    val sentToPhoneNumber =
        phoneNumber
            ?: phoneNumberOtpSentTo
                ?: return Result.failure(AuthenticationException("Phone number not specified."))

    return authManager.login(
        loginType = LoginType.Sms(phoneNumber = sentToPhoneNumber, code = code))
  }
}
