package io.privy.auth.customAuth

import io.privy.auth.AuthManager
import io.privy.auth.LoginType
import io.privy.auth.PrivyUser
import me.tatarka.inject.annotations.Inject

@Inject
public class RealLoginWithCustomAuth(private val authManager: AuthManager) : LoginWithCustomAuth {
  private var tokenProvider: TokenProvider? = null

  override fun setTokenProvider(tokenProvider: TokenProvider) {
    this.tokenProvider = tokenProvider

    // Also set it in auth manager so it can refresh sessions
    authManager.setTokenProvider(tokenProvider = tokenProvider)
  }

  override suspend fun loginWithCustomAccessToken(): Result<PrivyUser> {
    val tknProvider =
        tokenProvider
            ?:
            // If token provider is null, return an error
            return Result.failure(
                exception =
                    CustomAuthException(
                        message =
                            "Token provider must be set before calling loginWithCustomAccessToken."))

    val accessToken = tknProvider.invoke()

    return if (accessToken == null) {
      // IF ACCESS TOKEN IS NULL, THEN WHAT?
      // i think we should make sure user is logged out
      Result.failure(
          exception =
              CustomAuthException(
                  message =
                      "Access token retrieved from token provider is null, logging user out."))
    } else {
      authManager.login(loginType = LoginType.CustomAccessToken(token = accessToken))
    }
  }
}

public class CustomAuthException(message: String) : Exception(message)
